/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-do-not-access-private-class-members", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotAccessPrivateClassMembersCheck
extends CheckImplementationBase {
    private static final Set<String> ALLOWED_OBJECTS = CollectionUtils.asHashSet((Object[])new String[]{"self", "cls"});
    private static final String PRIVATE_MEMBER_PREFIX = "_";
    private static final String MAGIC_MEMBER_PREFIX = "__";
    private static final String MAGIC_MEMBER_SUFFIX = "__";
    private static final ETokenType[] MEMBER_ACCESS = new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER};
    private static final int MEMBER_IDENTIFIER_FOR_MEMBER_ACCESS = 2;
    private static final ETokenType[] CHAINED_MEMBER_ACCESS = new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.DOT, ETokenType.IDENTIFIER};
    private static final int MEMBER_IDENTIFIER_FOR_CHAINED_MEMBER_ACCESS = 4;

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        String containingMethodName = DoNotAccessPrivateClassMembersCheck.getContainingMethodName(entity);
        Set<String> classNames = DoNotAccessPrivateClassMembersCheck.getClassNames(entity);
        for (int indexOfFindingSequence : DoNotAccessPrivateClassMembersCheck.getStartingIndicesOfTypeSequence((UnmodifiableList<IToken>)tokens, MEMBER_ACCESS)) {
            this.checkForViolationAndCreateFinding((UnmodifiableList<IToken>)tokens, indexOfFindingSequence, 2, classNames, containingMethodName);
        }
        for (int indexOfFindingSequence : DoNotAccessPrivateClassMembersCheck.getStartingIndicesOfTypeSequence((UnmodifiableList<IToken>)tokens, CHAINED_MEMBER_ACCESS)) {
            this.checkForViolationAndCreateFinding((UnmodifiableList<IToken>)tokens, indexOfFindingSequence, 4, classNames, containingMethodName);
        }
    }

    private static String getContainingMethodName(ShallowEntity entity) {
        while (entity != null) {
            if (entity.getType() == EShallowEntityType.METHOD && !StringUtils.isEmpty((String)entity.getName())) {
                return entity.getName();
            }
            entity = entity.getParent();
        }
        return null;
    }

    private static Set<String> getClassNames(ShallowEntity statement) {
        HashSet<String> classNames = new HashSet<String>();
        for (ShallowEntity parent = statement.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != EShallowEntityType.TYPE || !parent.getSubtype().equals("class")) continue;
            DoNotAccessPrivateClassMembersCheck.getBaseClass((UnmodifiableList<IToken>)parent.ownStartTokens()).ifPresent(classNames::add);
            classNames.add(parent.getName());
        }
        return classNames;
    }

    private static Optional<String> getBaseClass(UnmodifiableList<IToken> classDefinitonTokens) {
        Integer baseClassIndex;
        List<Integer> baseClassIndices = DoNotAccessPrivateClassMembersCheck.getStartingIndicesOfTypeSequence(classDefinitonTokens, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN);
        if (baseClassIndices.size() == 1 && (baseClassIndex = baseClassIndices.getFirst()) != -1) {
            return Optional.of(((IToken)classDefinitonTokens.get(baseClassIndex + 1)).getText());
        }
        return Optional.empty();
    }

    private static List<Integer> getStartingIndicesOfTypeSequence(UnmodifiableList<IToken> tokens, ETokenType ... pattern) {
        return TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)(tokens.size() - 1), (ETokenType[])pattern);
    }

    private void checkForViolationAndCreateFinding(UnmodifiableList<IToken> tokens, int indexOfFindingSequence, int memberOffset, Set<String> classNames, String containingMethodName) {
        String memberName = ((IToken)tokens.get(indexOfFindingSequence + memberOffset)).getText();
        if (containingMethodName != null && containingMethodName.equals(memberName)) {
            return;
        }
        String callPrefix = ((IToken)tokens.get(indexOfFindingSequence)).getText();
        if (!ALLOWED_OBJECTS.contains(callPrefix) && !classNames.contains(callPrefix) && DoNotAccessPrivateClassMembersCheck.isPrivateMember(memberName) && !DoNotAccessPrivateClassMembersCheck.isMagicMember(memberName)) {
            this.buildFinding("Access of internal member " + MarkupUtils.formatAsSourceCode((String)TokenStreamTextUtils.concatTokenTexts((List)tokens.subList(indexOfFindingSequence, indexOfFindingSequence + memberOffset + 1))), this.buildLocation().forToken((IToken)tokens.get(indexOfFindingSequence))).createAndStore();
        }
    }

    private static boolean isPrivateMember(String memberName) {
        return memberName.startsWith(PRIVATE_MEMBER_PREFIX);
    }

    private static boolean isMagicMember(String memberName) {
        return memberName.startsWith("__") && memberName.endsWith("__");
    }
}

