/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.ESimulinkNameCheckType;
import eu.cqse.check.simulink.SimulinkNameChecker;
import java.util.List;
import java.util.Set;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Check(id="cqse.jmaab.ar_0001", languages={ELanguage.SIMULINK, ELanguage.MATLAB, ELanguage.LINE, ELanguage.TEXT, ELanguage.XML})
public class SimulinkInvalidCharactersInFileNamesCheck
extends CheckImplementationBase {
    private static final FindingPropertyList INVALID_CHARACTERS_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change file name to only use Single-byte alphanumeric characters (a-z, A-Z, 0-9) and Single-byte underscores (_)");
    private static final FindingPropertyList RESERVED_KEYWORD_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change file name to not be equivalent to a reserved MATLAB keyword");
    private static final FindingPropertyList FUNCTION_NAME_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change file name to not be equivalent to a MATLAB function name");
    @CheckOption(name="Disallow non-alphanumeric characters in file names", description="If set, file names that do not consist of single-byte alphanumeric characters (a-z, A-Z, 0-9) are disallowed.")
    private boolean disallowNonAlphanumericCharacters = true;
    @CheckOption(name="Disallow leading numbers in file names", description="If set, file names starting with digits are disallowed.")
    private boolean disallowStartWithNumbers = true;
    @CheckOption(name="Disallow leading underscores in file names", description="If set, file names starting with underscores are disallowed.")
    private boolean disallowStartWithUnderscore = true;
    @CheckOption(name="Disallow trailing underscores in file names", description="If set, file names ending with underscores are disallowed.")
    private boolean disallowEndWithUnderscore = true;
    @CheckOption(name="Disallow consecutive underscores in file names", description="If set, file names with consecutive underscores (e.g. '__') are disallowed.")
    private boolean disallowConsecutiveUnderscores = true;
    @CheckOption(name="Disallow file names as reserved MATLAB keywords", description="If set, file names matching reserved MATLAB keywords are disallowed.")
    private boolean disallowReservedMatlabKeyword = true;
    @CheckOption(name="Disallow file names as MATLAB function names", description="If set, file names matching MATLAB function names are disallowed.")
    private boolean disallowMatlabFunctionName = true;
    @CheckOption(name="Whitelisted file names", description="List of all file names that are explicitly allowed, separated by a comma. These names are ignored by this check.")
    private String whitelistedNames = "";

    public void execute() {
        String fileName = FileSystemUtils.getFilenameWithoutExtension((String)UniformPathUtils.getElementName((String)this.context.getUniformPath()));
        Set<ESimulinkNameCheckType> typesToCheck = SimulinkNameChecker.createTypesToCheckSetFromConfigurations(this.disallowNonAlphanumericCharacters, this.disallowStartWithNumbers, this.disallowConsecutiveUnderscores, this.disallowStartWithUnderscore, this.disallowEndWithUnderscore, this.disallowReservedMatlabKeyword, this.disallowMatlabFunctionName);
        List<ESimulinkNameCheckType> failedChecks = SimulinkNameChecker.checkName(fileName, typesToCheck, this.whitelistedNames);
        for (ESimulinkNameCheckType failedCheck : failedChecks) {
            this.createFindingFromNameCheckType(failedCheck);
        }
    }

    private void createFindingFromNameCheckType(ESimulinkNameCheckType checkType) {
        switch (checkType) {
            case ALPHANUMERIC_CHARACTER_USAGE: {
                this.buildFinding("File name contains invalid characters", this.buildLocation().forElement()).addFindingProperties(INVALID_CHARACTERS_RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_NUMBER: {
                this.buildFinding("File name starts with a digit", this.buildLocation().forElement()).addFindingProperties(INVALID_CHARACTERS_RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case CONSECUTIVE_UNDERSCORES_USAGE: {
                this.buildFinding("File name contains consecutive underscores", this.buildLocation().forElement()).addFindingProperties(INVALID_CHARACTERS_RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_UNDERSCORE: {
                this.buildFinding("File name starts with an underscore", this.buildLocation().forElement()).addFindingProperties(INVALID_CHARACTERS_RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_ENDS_WITH_UNDERSCORE: {
                this.buildFinding("File name ends with an underscore", this.buildLocation().forElement()).addFindingProperties(INVALID_CHARACTERS_RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_IS_RESERVED_MATLAB_KEYWORD: {
                this.buildFinding("File name is a reserved MATLAB keyword", this.buildLocation().forElement()).addFindingProperties(RESERVED_KEYWORD_RECOMMENDED_ACTION).createAndStore();
                break;
            }
            case NAME_IS_MATLAB_FUNCTION_NAME: {
                this.buildFinding("File name is a MATLAB function name", this.buildLocation().forElement()).addFindingProperties(FUNCTION_NAME_RECOMMENDED_ACTION).createAndStore();
                break;
            }
        }
    }
}

