/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0029", languages={ELanguage.SIMULINK})
public class SimulinkAssignmentBlockCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_NON_ITERATIVE = "Assignment block's simulation run-time diagnostic `Action if any output element is not assigned` is not set to `Error`";
    private static final String FINDING_MESSAGE_ITERATIVE = "Assignment block's simulation run-time diagnostic `Action if any output element is not assigned` is not set to `Warning` or `Error`";
    private static final FindingPropertyList RECOMMENDED_ACTION_NON_ITERATIVE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set block parameter `Action if any output element is not assigned` to Error.");
    private static final FindingPropertyList RECOMMENDED_ACTION_ITERATIVE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set block parameter `Action if any output element is not assigned` to Error or Warning.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("Assignment"), (boolean)false, (boolean)false)) {
            String outputInitialize = block.getParameter("OutputInitialize");
            if ("Initialize using input port <Y0>".equals(outputInitialize)) continue;
            String diagnosticForDimensions = block.getParameter("DiagnosticForDimensions");
            if (SimulinkAssignmentBlockCheck.isBlockInIteratorSubsystem(block)) {
                if (!"none".equalsIgnoreCase(diagnosticForDimensions)) continue;
                this.buildFinding(FINDING_MESSAGE_ITERATIVE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_ITERATIVE).createAndStore();
                continue;
            }
            if ("Error".equalsIgnoreCase(diagnosticForDimensions)) continue;
            this.buildFinding(FINDING_MESSAGE_NON_ITERATIVE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_NON_ITERATIVE).createAndStore();
        }
    }

    private static boolean isBlockInIteratorSubsystem(SimulinkBlock block) {
        return block.getParent().getSubBlocks().stream().anyMatch(subBlock -> "ForIterator".equals(subBlock.getType()) || "WhileIterator".equals(subBlock.getType()));
    }
}

