/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.mathworks.design.OptBusVirtuality", languages={ELanguage.SIMULINK})
public class SimulinkOptimalBusVirtualityCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Block that references a virtual bus crosses subsystem boundaries";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the referenced bus to a specified bus type and make the bus nonvirtual.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("BusCreator", "Inport", "InportShadow"), (boolean)false, (boolean)false)) {
            boolean virtualBusCrossesBoundaries;
            if (block.getType().equals("BusCreator")) {
                virtualBusCrossesBoundaries = SimulinkOptimalBusVirtualityCheck.virtualBusCreatorCrossesSubsystemBoundaries(block);
            } else {
                boolean bl = virtualBusCrossesBoundaries = SimulinkOptimalBusVirtualityCheck.inportIsConnectedToVirtualBusOutput(block) && SimulinkOptimalBusVirtualityCheck.inportSignalCrossesSubsystemBoundary(block) && SimulinkOptimalBusVirtualityCheck.isTopLevelInportBlock(block, model);
            }
            if (!virtualBusCrossesBoundaries) continue;
            this.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean virtualBusCreatorCrossesSubsystemBoundaries(SimulinkBlock busCreatorBlock) {
        for (SimulinkLine line : busCreatorBlock.getOutPort("1").getLines()) {
            if (!SimulinkOptimalBusVirtualityCheck.destinationPortIsOutportBlock(line) || !"off".equals(busCreatorBlock.getParameter("NonVirtualBus"))) continue;
            return true;
        }
        return false;
    }

    private static boolean destinationPortIsOutportBlock(SimulinkLine line) {
        SimulinkInPort inport = line.getDstPort();
        if (inport == null) {
            return false;
        }
        return "Outport".equals(inport.getBlock().getType());
    }

    private static boolean inportIsConnectedToVirtualBusOutput(SimulinkBlock inportBlock) {
        boolean inportBlockHasBusDataType = false;
        String dataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)inportBlock);
        if (!StringUtils.isEmpty((String)dataType)) {
            inportBlockHasBusDataType = dataType.contains("Bus:");
        }
        return inportBlockHasBusDataType && "off".equals(inportBlock.getParameter("BusOutputAsStruct"));
    }

    private static boolean isTopLevelInportBlock(SimulinkBlock inportBlock, SimulinkModel model) {
        SimulinkBlock parentBlock = inportBlock.getParent();
        return parentBlock != null && model.getName().equals(parentBlock.getName());
    }

    private static boolean inportSignalCrossesSubsystemBoundary(SimulinkBlock inportBlock) {
        SimulinkOutPort outPort = inportBlock.getOutPort("1");
        if (outPort == null) {
            return false;
        }
        UnmodifiableSet outLines = outPort.getLines();
        if (outLines.isEmpty()) {
            return false;
        }
        SimulinkLine line = ((SimulinkLine[])outLines.toArray((Object[])new SimulinkLine[0]))[0];
        if (line.getDstPort() == null || line.getDstPort().getBlock() == null) {
            return false;
        }
        String blockType = line.getDstPort().getBlock().getType();
        return !StringUtils.isEmpty((String)blockType) && Set.of("SubSystem", "Reference", "ModelReference").contains(blockType);
    }
}

