/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.na_0020", languages={ELanguage.SIMULINK})
public class SimulinkVariantSubsystemsInputCheck
extends CheckImplementationBase {
    private FindingPropertyList recommendedAction;
    private static final String FINDING_MESSAGE_VARIANT_SUBSYSTEM = "Subsystem %s shall have the same number of %s as its Variant Subsystem";
    private static final String FINDING_MESSAGE_VARIANT_MODEL = "Referenced Model %s shall have the same number of %s as its Variant Model";
    @CheckOption(name="Allow a different number of outports", description="Allows a different number of outports for a choice of a Variant Subsystem or Model if all outports have checked the parameter 'Specify output when unconnected'")
    private boolean allowDifferentCountOfOutports = false;
    @CheckOption(name="Check number of ports of variant subsystems", description="Check the number of in-/outports of Variant Subsystems and its children")
    private boolean checkVariantSubsystems = true;
    @CheckOption(name="Check number of ports of variant models", description="Check the number of in-/outports of Variant Models and its children")
    private boolean checkVariantModels = true;

    public void initialize() {
        String ports = "in-/outports";
        if (this.allowDifferentCountOfOutports) {
            ports = "inports";
        }
        this.recommendedAction = FindingPropertyList.singleton((String)"Recommended Action", (String)("Adjust the number of " + ports + " such that they are the same as of their variant block"));
    }

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock subsystem : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("SubSystem"), (boolean)false, (boolean)false)) {
            String variantParam = subsystem.getParameter("Variant");
            if (variantParam == null || !variantParam.equals("on")) continue;
            this.checkVariantSubsystem(subsystem);
        }
    }

    private void checkVariantSubsystem(SimulinkBlock variantSubsystem) {
        for (SimulinkBlock block : variantSubsystem.getSubBlocks()) {
            if (this.checkVariantSubsystems && block.isOfType("SubSystem")) {
                this.checkVariantSystem(variantSubsystem, block, FINDING_MESSAGE_VARIANT_SUBSYSTEM);
                continue;
            }
            if (!this.checkVariantModels || !block.isOfType("ModelReference")) continue;
            this.checkVariantSystem(variantSubsystem, block, FINDING_MESSAGE_VARIANT_MODEL);
        }
    }

    private void checkVariantSystem(SimulinkBlock variantSystem, SimulinkBlock choices, String message) {
        boolean inportsDiffer = choices.getInPorts().size() != variantSystem.getInPorts().size();
        boolean outportsDiffer = choices.getOutPorts().size() != variantSystem.getOutPorts().size();
        String ports = "in-/outports";
        if (outportsDiffer && this.allowDifferentCountOfOutports && SimulinkVariantSubsystemsInputCheck.outportParametersAreSet(variantSystem)) {
            outportsDiffer = false;
            ports = "inports";
        }
        if (inportsDiffer || outportsDiffer) {
            message = String.format(message, MarkupUtils.formatAsSourceCode((String)choices.getNamePretty()), ports);
            this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(choices)).addFindingProperties(this.recommendedAction).createAndStore();
        }
    }

    private static boolean outportParametersAreSet(SimulinkBlock variantSubsystem) {
        return variantSubsystem.getSubBlocks().stream().filter(block -> block.isOfType("Outport")).allMatch(block -> block.getParameter("OutputWhenUnConnected").equals("on"));
    }
}

