/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.logging.google;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.auth.oauth2.GoogleCredentials;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.logging.google.GoogleCloudMonitoredResourceLoader;
import com.teamscale.logging.google.IGoogleCloudLoggingRestClient;
import com.teamscale.logging.google.MonitoredResourceKubernetesContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.status.StatusLogger;
import org.conqat.engine.commons.util.JsonUtils;

public class GoogleCloudLogSender
implements AutoCloseable {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final int maxBatchSize;
    private final long maxInterval;
    private final long minInterval;
    private final List<LogEvent> batchedEvents = Collections.synchronizedList(new ArrayList());
    private final AtomicLong lastTimeFlushed;
    private final LogFlushingThread logFlushingThread;

    public GoogleCloudLogSender(int maxBatchSize, long maxInterval, long minInterval) throws ServiceCallException, IOException {
        this.maxBatchSize = maxBatchSize;
        this.maxInterval = maxInterval;
        this.minInterval = minInterval;
        this.lastTimeFlushed = new AtomicLong(System.currentTimeMillis());
        this.logFlushingThread = new LogFlushingThread();
        this.logFlushingThread.setDaemon(true);
        this.logFlushingThread.start();
    }

    public void send(LogEvent event) {
        this.batchedEvents.add(event);
        if (this.batchedEvents.size() >= this.maxBatchSize && System.currentTimeMillis() > this.lastTimeFlushed.get() + this.minInterval) {
            this.logFlushingThread.interrupt();
        }
    }

    @Override
    public void close() {
        this.logFlushingThread.close();
    }

    private class LogFlushingThread
    extends Thread
    implements AutoCloseable {
        private final MonitoredResourceKubernetesContainer resource;
        private final GoogleCredentials credentials;
        private String accessToken;
        private IGoogleCloudLoggingRestClient googleCloudLoggingRestClient;
        private volatile boolean running;

        public LogFlushingThread() throws IOException, ServiceCallException {
            super("Google Cloud Log Sender");
            this.running = true;
            this.resource = GoogleCloudMonitoredResourceLoader.loadKubernetesContainer();
            this.credentials = GoogleCredentials.getApplicationDefault();
            this.credentials.refreshIfExpired();
            this.accessToken = this.credentials.getAccessToken().getTokenValue();
            this.googleCloudLoggingRestClient = LogFlushingThread.getGoogleCloudLoggingRestClient(this.accessToken);
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Thread.sleep(GoogleCloudLogSender.this.maxInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.flush();
            }
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush() {
            ArrayList<LogEvent> eventsToFlush;
            List<LogEvent> list = GoogleCloudLogSender.this.batchedEvents;
            synchronized (list) {
                if (GoogleCloudLogSender.this.batchedEvents.isEmpty()) {
                    return;
                }
                eventsToFlush = new ArrayList<LogEvent>(GoogleCloudLogSender.this.batchedEvents);
                GoogleCloudLogSender.this.batchedEvents.clear();
            }
            String logName = "projects/" + this.resource.getLabels().getProjectId() + "/logs/teamscale-log";
            ArrayList<IGoogleCloudLoggingRestClient.LogEntry> logEntries = new ArrayList<IGoogleCloudLoggingRestClient.LogEntry>();
            for (LogEvent event : eventsToFlush) {
                logEntries.add(new IGoogleCloudLoggingRestClient.LogEntry(logName, this.resource, LogFlushingThread.convertLogLevelToCloudLoggingSeverity(event.getLevel()), event, new IGoogleCloudLoggingRestClient.StructuredJsonPayload(event)));
            }
            IGoogleCloudLoggingRestClient.LoggingApiRequestBody loggingApiRequestBody = new IGoogleCloudLoggingRestClient.LoggingApiRequestBody(logEntries);
            try {
                this.credentials.refreshIfExpired();
                String refreshedAccessToken = this.credentials.getAccessToken().getTokenValue();
                if (!refreshedAccessToken.equals(this.accessToken)) {
                    this.accessToken = refreshedAccessToken;
                    this.googleCloudLoggingRestClient = LogFlushingThread.getGoogleCloudLoggingRestClient(this.accessToken);
                }
                this.googleCloudLoggingRestClient.write(loggingApiRequestBody);
            }
            catch (Exception e) {
                LOGGER.error("Could not send logs to GCP: " + e.getMessage(), (Throwable)e);
            }
            GoogleCloudLogSender.this.lastTimeFlushed.set(System.currentTimeMillis());
        }

        @Override
        public void close() {
            this.running = false;
            this.interrupt();
        }

        private static IGoogleCloudLoggingRestClient getGoogleCloudLoggingRestClient(String accessToken) {
            return (IGoogleCloudLoggingRestClient)Retrofit.builder((String)"https://logging.googleapis.com/").withBearerAuthentication(accessToken).withInteractionLogger(LOGGER).withObjectMapper(((JsonMapper.Builder)JsonUtils.defaultObjectMapperBuilder().disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).build()).create(IGoogleCloudLoggingRestClient.class);
        }

        private static int convertLogLevelToCloudLoggingSeverity(Level level) {
            return switch (level.intLevel()) {
                case 100 -> 600;
                case 200 -> 500;
                case 300 -> 400;
                case 400 -> 200;
                case 500 -> 100;
                default -> 0;
            };
        }
    }
}

