/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.markdown;

import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.channel.RegexChannel;
import org.sonar.markdown.MarkdownOutput;

class HtmlListChannel
extends Channel<MarkdownOutput> {
    private OrderedListElementChannel orderedListElement = new OrderedListElementChannel();
    private UnorderedListElementChannel unorderedListElement = new UnorderedListElementChannel();
    private EndOfLine endOfLine = new EndOfLine();
    private boolean pendingListConstruction;

    HtmlListChannel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean consume(CodeReader code, MarkdownOutput output) {
        try {
            ListElementChannel currentChannel = null;
            if (code.getColumnPosition() == 0) {
                if (this.orderedListElement.consume(code, output)) {
                    currentChannel = this.orderedListElement;
                } else if (this.unorderedListElement.consume(code, output)) {
                    currentChannel = this.unorderedListElement;
                }
                if (currentChannel != null) {
                    while (this.endOfLine.consume(code, output) && currentChannel.consume(code, output)) {
                    }
                    output.append("</" + currentChannel.listElement + ">");
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pendingListConstruction = false;
        }
    }

    private static final class EndOfLine
    extends RegexChannel<MarkdownOutput> {
        public EndOfLine() {
            super("(\r?\n)|(\r)");
        }

        @Override
        protected void consume(CharSequence token, MarkdownOutput output) {
            output.append(token);
        }
    }

    private abstract class ListElementChannel
    extends RegexChannel<MarkdownOutput> {
        private String listElement;

        protected ListElementChannel(String markerRegexp, String listElement) {
            super("\\s*+" + markerRegexp + "\\s[^\r\n]*+");
            this.listElement = listElement;
        }

        @Override
        protected void consume(CharSequence token, MarkdownOutput output) {
            if (!HtmlListChannel.this.pendingListConstruction) {
                output.append("<" + this.listElement + ">");
                HtmlListChannel.this.pendingListConstruction = true;
            }
            output.append("<li>");
            output.append(token.subSequence(this.searchIndexOfFirstCharacter(token), token.length()));
            output.append("</li>");
        }

        private int searchIndexOfFirstCharacter(CharSequence token) {
            for (int index = 0; index < token.length(); ++index) {
                if (token.charAt(index) != '*' && !Character.isDigit(token.charAt(index))) continue;
                if (token.charAt(index + 1) == '.') {
                    ++index;
                }
                while (++index < token.length()) {
                    if (token.charAt(index) == ' ') continue;
                    return index;
                }
            }
            return token.length() - 1;
        }
    }

    private class UnorderedListElementChannel
    extends ListElementChannel {
        public UnorderedListElementChannel() {
            super("\\*", "ul");
        }
    }

    private class OrderedListElementChannel
    extends ListElementChannel {
        public OrderedListElementChannel() {
            super("\\d\\.", "ol");
        }
    }
}

