/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.FileExtensionPredicate;

@SonarLintSide
public class InputFileIndex
implements FileSystem.Index {
    private final Set<InputFile> inputFiles = new LinkedHashSet<InputFile>();
    private final Map<String, Set<InputFile>> filesByNameIndex = new LinkedHashMap<String, Set<InputFile>>();
    private final Map<String, Set<InputFile>> filesByExtensionIndex = new LinkedHashMap<String, Set<InputFile>>();
    private final SortedSet<String> languages = new TreeSet<String>();

    @Override
    public Iterable<InputFile> inputFiles() {
        return this.inputFiles;
    }

    public void doAdd(InputFile inputFile) {
        if (inputFile.language() != null) {
            this.languages.add(inputFile.language());
        }
        this.inputFiles.add(inputFile);
        this.filesByNameIndex.computeIfAbsent(inputFile.filename(), f -> new LinkedHashSet()).add(inputFile);
        this.filesByExtensionIndex.computeIfAbsent(FileExtensionPredicate.getExtension(inputFile), f -> new LinkedHashSet()).add(inputFile);
    }

    @Override
    public InputFile inputFile(String relativePath) {
        throw new UnsupportedOperationException("inputFile(String relativePath)");
    }

    @Override
    public Iterable<InputFile> getFilesByName(String filename) {
        return this.filesByNameIndex.get(filename);
    }

    @Override
    public Iterable<InputFile> getFilesByExtension(String extension) {
        return this.filesByExtensionIndex.get(extension);
    }

    protected SortedSet<String> languages() {
        return this.languages;
    }
}

