/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.connected;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.authentication.AuthenticationChecker;
import org.sonarsource.sonarlint.core.serverapi.organization.ServerOrganization;
import org.sonarsource.sonarlint.core.serverapi.system.DefaultValidationResult;
import org.sonarsource.sonarlint.core.serverapi.system.ValidationResult;
import org.sonarsource.sonarlint.core.serverconnection.ServerVersionAndStatusChecker;

public class ConnectionValidator {
    private final ServerApiHelper helper;

    public ConnectionValidator(ServerApiHelper helper) {
        this.helper = helper;
    }

    public CompletableFuture<ValidationResult> validateConnection() {
        ServerVersionAndStatusChecker serverChecker = new ServerVersionAndStatusChecker(new ServerApi(this.helper));
        AuthenticationChecker authChecker = new AuthenticationChecker(this.helper);
        return ((CompletableFuture)serverChecker.checkVersionAndStatusAsync().thenApply(check -> {
            Optional<ServerOrganization> organization;
            ValidationResult validateCredentials = authChecker.validateCredentials();
            Optional<String> organizationKey = this.helper.getOrganizationKey();
            if (validateCredentials.success() && organizationKey.isPresent() && (organization = new ServerApi(this.helper).organization().getOrganization(organizationKey.get(), new ProgressMonitor(null))).isEmpty()) {
                return new DefaultValidationResult(false, "No organizations found for key: " + organizationKey.get());
            }
            return validateCredentials;
        })).exceptionally(e -> new DefaultValidationResult(false, e.getCause().getMessage()));
    }
}

