/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import com.google.common.eventbus.Subscribe;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.clientapi.backend.plugin.PluginsService;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationRemovedEvent;
import org.sonarsource.sonarlint.core.languages.LanguageSupportRepository;
import org.sonarsource.sonarlint.core.plugin.PluginsRepository;
import org.sonarsource.sonarlint.core.plugin.commons.LoadedPlugins;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoadResult;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoader;
import org.sonarsource.sonarlint.core.serverconnection.storage.PluginsStorage;
import org.sonarsource.sonarlint.core.storage.StorageService;

@Named
@Singleton
public class PluginsServiceImpl
implements PluginsService {
    private final SonarLintLogger logger = SonarLintLogger.get();
    private final PluginsRepository pluginsRepository;
    private final LanguageSupportRepository languageSupportRepository;
    private final StorageService storageService;
    private final Set<Path> embeddedPluginPaths;
    private final Map<String, Path> connectedModeEmbeddedPluginPathsByKey;
    private final boolean enableDataflowBugDetection;

    public PluginsServiceImpl(PluginsRepository pluginsRepository, LanguageSupportRepository languageSupportRepository, StorageService storageService, InitializeParams params) {
        this.pluginsRepository = pluginsRepository;
        this.languageSupportRepository = languageSupportRepository;
        this.storageService = storageService;
        this.embeddedPluginPaths = params.getEmbeddedPluginPaths();
        this.connectedModeEmbeddedPluginPathsByKey = params.getConnectedModeEmbeddedPluginPathsByKey();
        this.enableDataflowBugDetection = params.getFeatureFlags().isEnableDataflowBugDetection();
    }

    public LoadedPlugins getEmbeddedPlugins() {
        LoadedPlugins loadedEmbeddedPlugins = this.pluginsRepository.getLoadedEmbeddedPlugins();
        if (loadedEmbeddedPlugins == null) {
            PluginsLoadResult result = PluginsServiceImpl.loadPlugins(this.languageSupportRepository.getEnabledLanguagesInStandaloneMode(), this.embeddedPluginPaths, this.enableDataflowBugDetection);
            loadedEmbeddedPlugins = result.getLoadedPlugins();
            this.pluginsRepository.setLoadedEmbeddedPlugins(loadedEmbeddedPlugins);
        }
        return loadedEmbeddedPlugins;
    }

    public LoadedPlugins getPlugins(String connectionId) {
        LoadedPlugins loadedPlugins = this.pluginsRepository.getLoadedPlugins(connectionId);
        if (loadedPlugins == null) {
            PluginsLoadResult result = this.loadPlugins(connectionId);
            loadedPlugins = result.getLoadedPlugins();
            this.pluginsRepository.setLoadedPlugins(connectionId, loadedPlugins);
        }
        return loadedPlugins;
    }

    private PluginsLoadResult loadPlugins(String connectionId) {
        PluginsStorage pluginsStorage = this.storageService.connection(connectionId).plugins();
        HashMap<String, Path> pluginsToLoadByKey = new HashMap<String, Path>();
        pluginsToLoadByKey.putAll(pluginsStorage.getStoredPluginPathsByKey());
        pluginsToLoadByKey.putAll(this.connectedModeEmbeddedPluginPathsByKey);
        HashSet<Path> pluginPaths = new HashSet<Path>(pluginsToLoadByKey.values());
        return PluginsServiceImpl.loadPlugins(this.languageSupportRepository.getEnabledLanguagesInConnectedMode(), pluginPaths, this.enableDataflowBugDetection);
    }

    private static PluginsLoadResult loadPlugins(Set<Language> enabledLanguages, Set<Path> pluginPaths, boolean enableDataflowBugDetection) {
        PluginsLoader.Configuration config = new PluginsLoader.Configuration(pluginPaths, enabledLanguages, enableDataflowBugDetection);
        return new PluginsLoader().load(config);
    }

    @Subscribe
    public void connectionRemoved(ConnectionConfigurationRemovedEvent e) {
        this.evictAll(e.getRemovedConnectionId());
    }

    private void evictAll(String connectionId) {
        this.logger.debug("Evict loaded plugins for connection '{}'", (Object)connectionId);
        this.pluginsRepository.unload(connectionId);
    }
}

