/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rule.extractor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.Plugin;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.rule.extractor.RulesDefinitionExtractorContainer;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDefinition;

public class RulesDefinitionExtractor {
    public List<SonarLintRuleDefinition> extractRules(Map<String, Plugin> pluginInstancesByKeys, Set<Language> enabledLanguages, boolean includeTemplateRules, boolean includeSecurityHotspots) {
        RulesDefinition.Context context;
        try {
            RulesDefinitionExtractorContainer container = new RulesDefinitionExtractorContainer(pluginInstancesByKeys);
            container.execute();
            context = container.getRulesDefinitionContext();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to extract rules metadata", e);
        }
        ArrayList<SonarLintRuleDefinition> rules = new ArrayList<SonarLintRuleDefinition>();
        for (RulesDefinition.Repository repoDef : context.repositories()) {
            Optional<Language> repoLanguage;
            if (repoDef.isExternal() || (repoLanguage = Language.forKey(repoDef.language())).isEmpty() || !enabledLanguages.contains((Object)repoLanguage.get())) continue;
            for (RulesDefinition.Rule ruleDef : repoDef.rules()) {
                if (RulesDefinitionExtractor.shouldIgnoreAsHotspot(includeSecurityHotspots, ruleDef) || RulesDefinitionExtractor.shouldIgnoreAsTemplate(includeTemplateRules, ruleDef)) continue;
                rules.add(new SonarLintRuleDefinition(ruleDef));
            }
        }
        return rules;
    }

    private static boolean shouldIgnoreAsTemplate(boolean includeTemplateRules, RulesDefinition.Rule ruleDef) {
        return ruleDef.template() && !includeTemplateRules;
    }

    private static boolean shouldIgnoreAsHotspot(boolean hotspotsEnabled, RulesDefinition.Rule ruleDef) {
        return ruleDef.type() == RuleType.SECURITY_HOTSPOT && !hotspotsEnabled;
    }
}

