/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.authentication;

import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.system.DefaultValidationResult;
import org.sonarsource.sonarlint.core.serverapi.system.ValidationResult;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class AuthenticationChecker {
    private final ServerApiHelper serverApiHelper;

    public AuthenticationChecker(ServerApiHelper serverApiHelper) {
        this.serverApiHelper = serverApiHelper;
    }

    public ValidationResult validateCredentials() {
        try (HttpClient.Response response = this.serverApiHelper.rawGet("api/authentication/validate?format=json");){
            int code = response.code();
            if (response.isSuccessful()) {
                String responseStr = response.bodyAsString();
                ValidateResponse validateResponse = new Gson().fromJson(responseStr, ValidateResponse.class);
                DefaultValidationResult defaultValidationResult = new DefaultValidationResult(validateResponse.valid, validateResponse.valid ? "Authentication successful" : "Authentication failed");
                return defaultValidationResult;
            }
            DefaultValidationResult defaultValidationResult = new DefaultValidationResult(false, "HTTP Connection failed (" + code + "): " + response.bodyAsString());
            return defaultValidationResult;
        }
    }

    private static class ValidateResponse {
        boolean valid;

        private ValidateResponse() {
        }
    }
}

