/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.commons.VulnerabilityProbability;
import org.sonarsource.sonarlint.core.serverapi.hotspot.HotspotApi;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspot;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Hotspots;

public class HotspotDownloader {
    private final Set<Language> enabledLanguages;

    public HotspotDownloader(Set<Language> enabledLanguages) {
        this.enabledLanguages = enabledLanguages;
    }

    public PullResult downloadFromPull(HotspotApi hotspotApi, String projectKey, String branchName, Optional<Instant> lastSync) {
        HotspotApi.HotspotsPullResult apiResult = hotspotApi.pullHotspots(projectKey, branchName, this.enabledLanguages, lastSync.map(Instant::toEpochMilli).orElse(null));
        List<ServerHotspot> changedHotspots = apiResult.getHotspots().stream().filter(Predicate.not(Hotspots.HotspotLite::getClosed)).map(HotspotDownloader::convertLiteHotspot).collect(Collectors.toList());
        Set<String> closedIssueKeys = apiResult.getHotspots().stream().filter(Hotspots.HotspotLite::getClosed).map(Hotspots.HotspotLite::getKey).collect(Collectors.toSet());
        return new PullResult(Instant.ofEpochMilli(apiResult.getTimestamp().getQueryTimestamp()), changedHotspots, closedIssueKeys);
    }

    private static ServerHotspot convertLiteHotspot(Hotspots.HotspotLite liteHotspotFromWs) {
        Instant creationDate = Instant.ofEpochMilli(liteHotspotFromWs.getCreationDate());
        return new ServerHotspot(liteHotspotFromWs.getKey(), liteHotspotFromWs.getRuleKey(), liteHotspotFromWs.getMessage(), liteHotspotFromWs.getFilePath(), HotspotDownloader.toServerHotspotTextRange(liteHotspotFromWs.getTextRange()), creationDate, HotspotDownloader.fromHotspotLite(liteHotspotFromWs), VulnerabilityProbability.valueOf(liteHotspotFromWs.getVulnerabilityProbability()), liteHotspotFromWs.getAssignee());
    }

    private static HotspotReviewStatus fromHotspotLite(Hotspots.HotspotLite hotspot) {
        String status = hotspot.getStatus();
        String resolution = hotspot.hasResolution() ? hotspot.getResolution() : null;
        return HotspotReviewStatus.fromStatusAndResolution(status, resolution);
    }

    private static TextRangeWithHash toServerHotspotTextRange(Hotspots.TextRange textRange) {
        return new TextRangeWithHash(textRange.getStartLine(), textRange.getStartLineOffset(), textRange.getEndLine(), textRange.getEndLineOffset(), textRange.getHash());
    }

    public static class PullResult {
        private final Instant queryTimestamp;
        private final List<ServerHotspot> changedHotspots;
        private final Set<String> closedHotspotKeys;

        public PullResult(Instant queryTimestamp, List<ServerHotspot> changedHotspots, Set<String> closedHotspotKeys) {
            this.queryTimestamp = queryTimestamp;
            this.changedHotspots = changedHotspots;
            this.closedHotspotKeys = closedHotspotKeys;
        }

        public Instant getQueryTimestamp() {
            return this.queryTimestamp;
        }

        public List<ServerHotspot> getChangedHotspots() {
            return this.changedHotspots;
        }

        public Set<String> getClosedHotspotKeys() {
            return this.closedHotspotKeys;
        }
    }
}

