/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.events;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.push.IssueChangedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.RuleSetChangedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.SecurityHotspotChangedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.SecurityHotspotClosedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.SecurityHotspotRaisedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.TaintVulnerabilityClosedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.TaintVulnerabilityRaisedEvent;
import org.sonarsource.sonarlint.core.serverapi.stream.EventStream;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.events.EventDispatcher;
import org.sonarsource.sonarlint.core.serverconnection.events.ServerEventHandler;
import org.sonarsource.sonarlint.core.serverconnection.events.hotspot.UpdateStorageOnSecurityHotspotChanged;
import org.sonarsource.sonarlint.core.serverconnection.events.hotspot.UpdateStorageOnSecurityHotspotClosed;
import org.sonarsource.sonarlint.core.serverconnection.events.hotspot.UpdateStorageOnSecurityHotspotRaised;
import org.sonarsource.sonarlint.core.serverconnection.events.issue.UpdateStorageOnIssueChanged;
import org.sonarsource.sonarlint.core.serverconnection.events.ruleset.UpdateStorageOnRuleSetChanged;
import org.sonarsource.sonarlint.core.serverconnection.events.taint.UpdateStorageOnTaintVulnerabilityClosed;
import org.sonarsource.sonarlint.core.serverconnection.events.taint.UpdateStorageOnTaintVulnerabilityRaised;

public class ServerEventsAutoSubscriber {
    private final AtomicReference<EventStream> eventStream = new AtomicReference();
    private final EventDispatcher coreEventRouter;
    private final Set<Language> enabledLanguages;

    public static EventDispatcher getCoreEventHandlers(ConnectionStorage storage) {
        return new EventDispatcher().dispatch(RuleSetChangedEvent.class, new UpdateStorageOnRuleSetChanged(storage)).dispatch(IssueChangedEvent.class, new UpdateStorageOnIssueChanged(storage)).dispatch(TaintVulnerabilityRaisedEvent.class, new UpdateStorageOnTaintVulnerabilityRaised(storage)).dispatch(TaintVulnerabilityClosedEvent.class, new UpdateStorageOnTaintVulnerabilityClosed(storage)).dispatch(SecurityHotspotRaisedEvent.class, new UpdateStorageOnSecurityHotspotRaised(storage)).dispatch(SecurityHotspotChangedEvent.class, new UpdateStorageOnSecurityHotspotChanged(storage)).dispatch(SecurityHotspotClosedEvent.class, new UpdateStorageOnSecurityHotspotClosed(storage));
    }

    public ServerEventsAutoSubscriber(ConnectionStorage storage, Set<Language> enabledLanguages) {
        this.coreEventRouter = ServerEventsAutoSubscriber.getCoreEventHandlers(storage);
        this.enabledLanguages = enabledLanguages;
    }

    public void subscribePermanently(ServerApi serverApi, Set<String> projectKeys, Consumer<ServerEvent> eventConsumer) {
        this.cancelSubscription();
        if (!projectKeys.isEmpty() && !this.enabledLanguages.isEmpty()) {
            this.attemptSubscription(serverApi, projectKeys, this.enabledLanguages, e -> this.notifyHandlers(e, eventConsumer));
        }
    }

    private void notifyHandlers(ServerEvent serverEvent, Consumer<ServerEvent> clientEventConsumer) {
        this.coreEventRouter.handle(serverEvent);
        clientEventConsumer.accept(serverEvent);
    }

    private void attemptSubscription(ServerApi serverApi, Set<String> projectKeys, Set<Language> enabledLanguages, ServerEventHandler<ServerEvent> eventConsumer) {
        this.eventStream.set(serverApi.push().subscribe(projectKeys, enabledLanguages, eventConsumer::handle));
    }

    private void cancelSubscription() {
        if (this.eventStream.get() != null) {
            this.eventStream.get().close();
        }
    }

    public void stop() {
        this.cancelSubscription();
    }
}

