/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.sync;

import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.branch.SonarProjectBranchServiceImpl;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.clientapi.client.sync.DidSynchronizeConfigurationScopeParams;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.event.ActiveSonarProjectBranchChanged;
import org.sonarsource.sonarlint.core.languages.LanguageSupportRepository;
import org.sonarsource.sonarlint.core.progress.ProgressNotifier;
import org.sonarsource.sonarlint.core.progress.TaskManager;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverconnection.ServerConnection;
import org.sonarsource.sonarlint.core.storage.StorageService;

@Named
@Singleton
public class SynchronizationServiceImpl {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final SonarLintClient client;
    private final ConfigurationRepository configurationRepository;
    private final LanguageSupportRepository languageSupportRepository;
    private final SonarProjectBranchServiceImpl branchService;
    private final ServerApiProvider serverApiProvider;
    private final TaskManager taskManager;
    private final StorageService storageService;
    private final Set<String> connectedModeEmbeddedPluginKeys;
    private final boolean synchronizationEnabled;
    private ScheduledExecutorService scheduledSynchronizer;

    public SynchronizationServiceImpl(SonarLintClient client, ConfigurationRepository configurationRepository, LanguageSupportRepository languageSupportRepository, SonarProjectBranchServiceImpl branchService, ServerApiProvider serverApiProvider, StorageService storageService, InitializeParams params) {
        this.client = client;
        this.configurationRepository = configurationRepository;
        this.languageSupportRepository = languageSupportRepository;
        this.branchService = branchService;
        this.serverApiProvider = serverApiProvider;
        this.taskManager = new TaskManager(client);
        this.storageService = storageService;
        this.connectedModeEmbeddedPluginKeys = params.getConnectedModeEmbeddedPluginPathsByKey().keySet();
        this.synchronizationEnabled = params.getFeatureFlags().shouldSynchronizeProjects();
    }

    @PostConstruct
    public void startScheduledSync() {
        if (!this.synchronizationEnabled) {
            return;
        }
        this.scheduledSynchronizer = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "SonarLint Local Storage Synchronizer"));
        this.scheduledSynchronizer.scheduleAtFixedRate(this::safeAutoSync, 1L, 3600L, TimeUnit.SECONDS);
    }

    private void safeAutoSync() {
        try {
            this.autoSync();
        }
        catch (Exception e) {
            LOG.error("Error during the auto-sync", e);
        }
    }

    private void autoSync() {
        Map<String, List<BoundConfigurationScope>> bindingsPerConnectionId = this.configurationRepository.getEffectiveBindingForLeafConfigScopesById().entrySet().stream().collect(Collectors.groupingBy(e -> ((Binding)e.getValue()).getConnectionId(), Collectors.mapping(e -> new BoundConfigurationScope((String)e.getKey(), ((Binding)e.getValue()).getSonarProjectKey()), Collectors.toList())));
        this.autoSync(bindingsPerConnectionId);
    }

    private void autoSync(Map<String, List<BoundConfigurationScope>> bindingsPerConnectionId) {
        if (bindingsPerConnectionId.isEmpty()) {
            return;
        }
        this.taskManager.startTask(null, "Synchronizing projects...", null, false, false, progressNotifier -> {
            int connectionsCount = bindingsPerConnectionId.keySet().size();
            float progressGap = 100.0f / (float)connectionsCount;
            float progress = 0.0f;
            HashSet<String> synchronizedConfScopeIds = new HashSet<String>();
            for (Map.Entry entry : bindingsPerConnectionId.entrySet()) {
                String connectionId = (String)entry.getKey();
                progressNotifier.notify("Synchronizing with '" + connectionId + "'...", Math.round(progress));
                this.autoSync(connectionId, (List)entry.getValue(), (ProgressNotifier)progressNotifier, (Set<String>)synchronizedConfScopeIds, progress, progressGap);
                progress += progressGap;
            }
            if (!synchronizedConfScopeIds.isEmpty()) {
                this.client.didSynchronizeConfigurationScopes(new DidSynchronizeConfigurationScopeParams(synchronizedConfScopeIds));
            }
        });
    }

    private void autoSync(String connectionId, List<BoundConfigurationScope> boundConfigurationScopes, ProgressNotifier notifier, Set<String> synchronizedConfScopeIds, float progress, float progressGap) {
        if (boundConfigurationScopes.isEmpty()) {
            return;
        }
        this.serverApiProvider.getServerApi(connectionId).ifPresent(serverApi -> {
            ServerConnection serverConnection = this.getServerConnection(connectionId, (ServerApi)serverApi);
            float subProgressGap = progressGap / (float)boundConfigurationScopes.size();
            float subProgress = progress;
            for (BoundConfigurationScope scope : boundConfigurationScopes) {
                notifier.notify("Synchronizing project '" + scope.sonarProjectKey + "'...", Math.round(subProgress));
                this.autoSyncBoundConfigurationScope(scope, (ServerApi)serverApi, serverConnection, synchronizedConfScopeIds);
                subProgress += subProgressGap;
            }
        });
    }

    @NotNull
    public ServerConnection getServerConnection(String connectionId, ServerApi serverApi) {
        return new ServerConnection(this.storageService.getStorageFacade(), connectionId, serverApi.isSonarCloud(), this.languageSupportRepository.getEnabledLanguagesInConnectedMode(), this.connectedModeEmbeddedPluginKeys);
    }

    private void autoSyncBoundConfigurationScope(BoundConfigurationScope boundScope, ServerApi serverApi, ServerConnection serverConnection, Set<String> synchronizedConfScopeIds) {
        this.branchService.getEffectiveActiveSonarProjectBranch(boundScope.configurationScopeId).ifPresent(branch -> {
            serverConnection.syncServerIssuesForProject(serverApi, boundScope.sonarProjectKey, (String)branch);
            if (this.languageSupportRepository.areTaintVulnerabilitiesSupported()) {
                serverConnection.syncServerTaintIssuesForProject(serverApi, boundScope.sonarProjectKey, (String)branch);
            }
            serverConnection.syncServerHotspotsForProject(serverApi, boundScope.sonarProjectKey, (String)branch);
            synchronizedConfScopeIds.add(boundScope.configurationScopeId);
        });
    }

    @Subscribe
    public void onSonarProjectBranchChanged(ActiveSonarProjectBranchChanged changedEvent) {
        if (!this.synchronizationEnabled) {
            return;
        }
        String configurationScopeId = changedEvent.getConfigurationScopeId();
        this.configurationRepository.getEffectiveBinding(configurationScopeId).ifPresent(binding -> this.autoSync(Map.of(Objects.requireNonNull(binding.getConnectionId()), List.of(new BoundConfigurationScope(configurationScopeId, binding.getSonarProjectKey())))));
    }

    public void fetchProjectIssues(Binding binding, String activeBranch) {
        this.serverApiProvider.getServerApi(binding.getConnectionId()).ifPresent(serverApi -> {
            ServerConnection serverConnection = this.getServerConnection(binding.getConnectionId(), (ServerApi)serverApi);
            serverConnection.downloadServerIssuesForProject((ServerApi)serverApi, binding.getSonarProjectKey(), activeBranch);
        });
    }

    public void fetchFileIssues(Binding binding, String serverFileRelativePath, String activeBranch) {
        this.serverApiProvider.getServerApi(binding.getConnectionId()).ifPresent(serverApi -> {
            ServerConnection serverConnection = this.getServerConnection(binding.getConnectionId(), (ServerApi)serverApi);
            serverConnection.downloadServerIssuesForFile((ServerApi)serverApi, binding.getSonarProjectKey(), serverFileRelativePath, activeBranch);
        });
    }

    public void fetchProjectHotspots(Binding binding, String activeBranch) {
        this.serverApiProvider.getServerApi(binding.getConnectionId()).ifPresent(serverApi -> {
            ServerConnection serverConnection = this.getServerConnection(binding.getConnectionId(), (ServerApi)serverApi);
            serverConnection.downloadAllServerHotspots((ServerApi)serverApi, binding.getSonarProjectKey(), activeBranch, new ProgressMonitor(null));
        });
    }

    public void fetchFileHotspots(Binding binding, String activeBranch, String serverFilePath) {
        this.serverApiProvider.getServerApi(binding.getConnectionId()).ifPresent(serverApi -> {
            ServerConnection serverConnection = this.getServerConnection(binding.getConnectionId(), (ServerApi)serverApi);
            serverConnection.downloadAllServerHotspotsForFile((ServerApi)serverApi, binding.getSonarProjectKey(), serverFilePath, activeBranch);
        });
    }

    @PreDestroy
    public void shutdown() {
        if (this.scheduledSynchronizer != null && !MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.scheduledSynchronizer, (long)5L, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.warn("Unable to stop synchronizer executor service in a timely manner");
        }
    }

    private static class BoundConfigurationScope {
        private final String configurationScopeId;
        private final String sonarProjectKey;

        private BoundConfigurationScope(String configurationScopeId, String sonarProjectKey) {
            this.configurationScopeId = configurationScopeId;
            this.sonarProjectKey = sonarProjectKey;
        }
    }
}

