/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.AbstractDuplicateBranchImplementationCheck;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.StatementTree;

@Rule(key="S1871")
public class DuplicateBranchImplementationCheck
extends AbstractDuplicateBranchImplementationCheck {
    public static final String KEY = "S1871";
    private static final String MESSAGE = "This %s's code block is the same as the block for the %s on line %s.";

    @Override
    protected void reportAllDuplicateBranches(SyntaxToken keyword) {
    }

    @Override
    protected void reportTwoDuplicateBranches(String branchType, List<StatementTree> originalBranch, List<StatementTree> duplicateBranch) {
        String message = String.format(MESSAGE, branchType, branchType, ((PHPTree)((Object)originalBranch.get(0))).getLine());
        this.context().newIssue(this, duplicateBranch.get(0), DuplicateBranchImplementationCheck.getLast(duplicateBranch), message).secondary(originalBranch.get(0), DuplicateBranchImplementationCheck.getLast(originalBranch), "Original");
    }

    private static StatementTree getLast(List<StatementTree> statements) {
        return statements.get(statements.size() - 1);
    }
}

