/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1765")
public class VarKeywordUsageCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1765";
    private static final String MESSAGE = "Replace the \"var\" keyword with the modifier \"public\".";

    @Override
    public void visitClassPropertyDeclaration(ClassPropertyDeclarationTree tree) {
        SyntaxToken varToken = VarKeywordUsageCheck.getVarModifier(tree);
        if (varToken != null) {
            this.context().newIssue(this, varToken, MESSAGE);
        }
        super.visitClassPropertyDeclaration(tree);
    }

    private static SyntaxToken getVarModifier(ClassPropertyDeclarationTree tree) {
        for (SyntaxToken modifier : tree.modifierTokens()) {
            if (!PHPKeyword.VAR.getValue().equals(modifier.text())) continue;
            return modifier;
        }
        return null;
    }
}

