/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.php.tree.impl.expression.LiteralTreeImpl;
import org.sonar.php.utils.collections.MapBuilder;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S2701")
public class BooleanOrNullLiteralInAssertionsCheck
extends PhpUnitCheck {
    private static final String MESSAGE = "Use %s instead.";
    private static final Set<String> HANDLED_ASSERTIONS = Set.of("assertEquals", "assertSame", "assertNotEquals", "assertNotSame");
    private static final Set<String> INVERSE_ASSERTIONS = Set.of("assertNotSame", "assertNotEquals");
    private static final Map<String, String> REPLACEMENT_ASSERTIONS = MapBuilder.builder().put("true", "assertTrue()").put("false", "assertFalse()").put("null", "assertNull()").put("!true", "assertNotTrue()").put("!false", "assertNotFalse()").put("!null", "assertNotNull()").build();

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if (!this.isPhpUnitTestCase()) {
            return;
        }
        BooleanOrNullLiteralInAssertionsCheck.getAssertion(tree).ifPresent(a -> {
            if (HANDLED_ASSERTIONS.contains(a.name())) {
                this.verifyAssertion(tree, a.name());
            }
        });
        super.visitFunctionCall(tree);
    }

    private void verifyAssertion(FunctionCallTree tree, String assertionName) {
        BooleanOrNullLiteralInAssertionsCheck.findLiteralArgument(tree).ifPresent(l -> this.suggestAlternative((LiteralTreeImpl)l, tree, assertionName));
    }

    private void suggestAlternative(LiteralTreeImpl literalTree, FunctionCallTree functionCallTree, String assertionName) {
        Object literalValue = literalTree.value().toLowerCase(Locale.ROOT);
        if (INVERSE_ASSERTIONS.contains(assertionName)) {
            literalValue = "!" + (String)literalValue;
        }
        this.newIssue(functionCallTree, String.format(MESSAGE, REPLACEMENT_ASSERTIONS.get(literalValue)));
    }

    private static Optional<LiteralTreeImpl> findLiteralArgument(FunctionCallTree tree) {
        Optional<CallArgumentTree> expected = CheckUtils.argument(tree, "expected", 0);
        Optional<CallArgumentTree> actual = CheckUtils.argument(tree, "actual", 1);
        if (!expected.isPresent() || !actual.isPresent()) {
            return Optional.empty();
        }
        ExpressionTree expectedValue = expected.get().value();
        ExpressionTree actualValue = actual.get().value();
        if (BooleanOrNullLiteralInAssertionsCheck.isLiteral(expectedValue)) {
            return Optional.of((LiteralTreeImpl)expectedValue);
        }
        if (BooleanOrNullLiteralInAssertionsCheck.isLiteral(actualValue)) {
            return Optional.of((LiteralTreeImpl)actualValue);
        }
        return Optional.empty();
    }

    private static boolean isLiteral(ExpressionTree tree) {
        return tree.is(Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NULL_LITERAL);
    }
}

