/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.lexical;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.utils.Patterns;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class InternalSyntaxTrivia
extends PHPTree
implements SyntaxTrivia {
    private final String comment;
    private final int column;
    private int startLine;
    private int endLine;
    private int endColumn;

    public InternalSyntaxTrivia(String comment, int startLine, int column) {
        this.comment = comment;
        this.startLine = startLine;
        this.column = column;
        this.calculateEndOffsets();
    }

    private void calculateEndOffsets() {
        String[] lines = Patterns.LINEBREAK_PATTERN.split(this.comment, -1);
        this.endColumn = this.column + this.comment.length();
        this.endLine = this.startLine + lines.length - 1;
        if (this.endLine != this.startLine) {
            this.endColumn = lines[lines.length - 1].length();
        }
    }

    @Override
    public String text() {
        return this.comment;
    }

    @Override
    public List<SyntaxTrivia> trivias() {
        return Collections.emptyList();
    }

    @Override
    public int line() {
        return this.startLine;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public int endLine() {
        return this.endLine;
    }

    @Override
    public int endColumn() {
        return this.endColumn;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TRIVIA;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        throw new UnsupportedOperationException();
    }

    public static SyntaxTrivia create(String comment, int startLine, int column) {
        return new InternalSyntaxTrivia(comment, startLine, column);
    }

    @Override
    public int getLine() {
        return this.startLine;
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitTrivia(this);
    }

    @Override
    public SyntaxToken getFirstToken() {
        return this;
    }

    @Override
    public SyntaxToken getLastToken() {
        return this;
    }
}

