import{_ as s,c as a,ak as t,o}from"./chunks/framework.D4LivsWb.js";const h=JSON.parse('{"title":"Frequently Asked Questions (FAQ)","description":"","frontmatter":{"pageClass":"condensed-summary"},"headers":[],"relativePath":"faq/index.md","filePath":"faq/index.md"}'),i={name:"faq/index.md"};function n(r,e,l,c,m,d){return o(),a("div",null,[...e[0]||(e[0]=[t('<h1 id="frequently-asked-questions-faq" tabindex="-1">Frequently Asked Questions (FAQ) <a class="header-anchor" href="#frequently-asked-questions-faq" aria-label="Permalink to &quot;Frequently Asked Questions (FAQ)&quot;">​</a></h1><h2 id="installation-setup" tabindex="-1">Installation &amp; Setup <a class="header-anchor" href="#installation-setup" aria-label="Permalink to &quot;Installation &amp; Setup&quot;">​</a></h2><details class="details custom-block"><summary>What are Teamscale&#39;s system requirements?</summary><p>Please refer to the <a href="./../reference/system-requirements/">system requirements page</a>.</p></details><details class="details custom-block"><summary>Is Teamscale available as docker image?</summary><p><strong>Yes</strong>. Please see <a href="https://hub.docker.com/r/cqse/teamscale/" target="_blank" rel="noreferrer">our Docker Hub page</a>.</p></details><details class="details custom-block"><summary>Does the Teamscale server need internet access?</summary><p><strong>No</strong>. Teamscale will only connect to servers you explicitly tell it about (e.g., your source code repositories or issue tracker).</p></details><details class="details custom-block"><summary>Do I need to change my build for Teamscale&#39;s code analysis?</summary><p><strong>No</strong>. As Teamscale connects directly to your version control systems like Git, the code analysis operates independently.</p></details><h2 id="operations" tabindex="-1">Operations <a class="header-anchor" href="#operations" aria-label="Permalink to &quot;Operations&quot;">​</a></h2><details class="details custom-block"><summary>Is it expected that the size of the storage directory grows during a rollback?</summary><p>Yes, during a rollback, it is possible that larger amounts of temporary data are created. It may take some time until the regular storage cleanup has freed up the disk space again.</p></details><h2 id="licensing" tabindex="-1">Licensing <a class="header-anchor" href="#licensing" aria-label="Permalink to &quot;Licensing&quot;">​</a></h2><details class="details custom-block"><summary>You charge for contributors. What is a contributor and how do you count them?</summary><p><a href="https://teamscale.com/pricing" target="_blank" rel="noreferrer">The license price</a> is based on the number of contributors. A contributor is both an active named user logging into the Teamscale UI or using the REST API, and a developer whose code is analyzed by Teamscale (called committer). As active users and committers will typically overlap a lot, we count both separately and use the maximum of both numbers as the contributor count. Additionally, we only count users or committers that have been active during the last 180 days. So if you had users who tried Teamscale but did not stick with it, they will not affect your license cost.</p><p>A committer is a developer who has committed any code that is analyzed by Teamscale in the last 180 days. If only parts of your repository are analyzed by Teamscale, e.g. <code>src/main</code> is analyzed but not <code>src/prototype</code>, only the commits that contain changes to the analyzed code contribute to the number of committers. Teamscale applies different heuristics to resolve duplicates if developers used multiple names when committing code:</p><ul><li>Different committer names but the same email address count as one committer</li><li>Name order: <code>Jane Doe</code>, <code>Doe Jane</code> and <code>Doe, Jane</code> count as one committer</li></ul><p>If a developer used multiple names that cannot be mapped by Teamscale automatically, you can provide aliases to Teamscale. Aliases allow you to map multiple committer names to one Teamscale user. If <code>Jane Doe</code> also committed as <code>ID_112347</code>, you can add <code>ID_112345</code> as alias in her Teamscale user profile. All commits of <code>Jane Doe</code> and <code>ID_112347</code> will now belong to the same committer.</p><p>You can view all committers and their aliases in the <em>System</em> &gt; <em>System Information</em> view by clicking on <em>Active committers</em>.</p></details><details class="details custom-block"><summary>Do I have to pay for bots and technical users that commit code?</summary><p><strong>No</strong>, you do not have to pay for bots and technical users. Teamscale excludes some well-known technical users such as the GitHub Merge Bot and the default SAP usernames <code>DDIC</code> and <code>SAP*</code>. But it is not possible for Teamscale to identify all technical users automatically. Contact our support to let us know which technical users you have. We will take this into account when billing.</p></details><details class="details custom-block"><summary>Can I have an additional Teamscale instance as part of a test environment?</summary><p><strong>Yes</strong>. If you operate Teamscale on premises, you can install a separate Teamscale instance for testing without additional cost. In fact, you are allowed to install and operate as many Teamscale instances as you like, as long as the total number of contributors stays within the amount mentioned in your license contract.</p><p>These instances may e.g. be used for experimenting with new features or doing acceptance testing of new versions. You may even have multiple production instances in case your development teams work in separate network segments across your organization.</p></details><h2 id="updates" tabindex="-1">Updates <a class="header-anchor" href="#updates" aria-label="Permalink to &quot;Updates&quot;">​</a></h2><details class="details custom-block"><summary>How often are Teamscale updates published?</summary><p>Usually, there are weekly patch releases for the last 2-3 release lines (e.g., <code>2024.8.x</code> and <code>2024.9.x</code>). Feature releases are published roughly every six weeks.</p></details><details class="details custom-block"><summary>Does only the latest Teamscale release receive updates?</summary><p><strong>No</strong>, we try to support the last 2-3 release lines (e.g., <code>2024.8.x</code> and <code>2024.9.x</code>). However, we recommend to update to the latest version, as this includes the full feature set. Bug fixes for older releases will also be contained in newer releases.</p></details><details class="details custom-block"><summary>Which kinds of updates require a re-analysis of the Teamscale project?</summary><p>There are two kinds of Teamscale releases:</p><ol><li><strong>Patch releases</strong>, which usually don&#39;t require a re-analysis</li><li><strong>Feature releases</strong>, which require a re-analysis.</li></ol><p>See also next question.</p></details><details class="details custom-block"><summary>How do I know if I&#39;m installing a feature or a patch release?</summary><ul><li>Patch releases only change the last digit of the version number (e.g., <strong>2024.9.0</strong> → <strong>2024.9.5</strong>).</li><li>Feature updates change the year and/or the middle digit, e.g., <ul><li><strong>2024.8.0</strong> → <strong>2024.9.0</strong></li><li><strong>2024.8.0</strong> → <strong>2025.1.0</strong></li></ul></li></ul></details><details class="details custom-block"><summary>How can I find out which version of Teamscale I have?</summary><ul><li>If Teamscale is running, click on <i class="large grey question icon"></i> in the upper right corner, then click <code>About Teamscale</code>.</li><li>If Teamscale is <strong>not</strong> running, please check the <code>set VERSION</code> line in the file <code>teamscale.bat</code>.</li></ul></details><details class="details custom-block"><summary>Where can I find more about the features &amp; bug fixes contained in a specific release?</summary><p>Consider subscribing to our <a href="https://teamscale.com/newsletter" target="_blank" rel="noreferrer">release newsletter</a> (sent once every six weeks for feature releases) and check <a href="./../changelog/">Teamscale&#39;s changelog</a>.</p></details><details class="details custom-block"><summary>Do I need a new license to update Teamscale?</summary><p><strong>No</strong>, Teamscale updates are free!</p></details><details class="details custom-block"><summary>Why is a re-analysis necessary?</summary><p>When you change important settings for a project or its analysis profile, many analysis results will change, e.g. findings, metrics, coverage, ... In order to get consistent metric trends, Test Gap results and to avoid hard-to-explain jumps in metric values, Teamscale re-analyzes the complete history of the project (as far back as configured in the project settings). This ensures you always have a consistent and explainable view on your data.</p></details><details class="details custom-block"><summary>How do I avoid downtime after Teamscale updates?</summary><p>We recommend to <a href="./../howto/updating-teamscale/shadow-instance/">set up a <em>shadow instance</em></a> running on another port (see file <code>config/teamscale.properties</code>). As soon as the new instance has finished re-analyzing the projects, the old instance can be shut down and the port of the new instance can be set to match the old one. This process is even easier when a tool like NGINX is <a href="./../howto/configuring-reverse-proxy/#nginx">configured as a reverse proxy</a>.</p></details><details class="details custom-block"><summary>Can I transfer my test coverage to the new instance?</summary><p><strong>Yes</strong>, by importing a project backup that was created on the old Teamscale instance.</p></details><h2 id="users-authorization" tabindex="-1">Users &amp; Authorization <a class="header-anchor" href="#users-authorization" aria-label="Permalink to &quot;Users &amp; Authorization&quot;">​</a></h2><details class="details custom-block"><summary>What are the default credentials (username, password) for the very first login?</summary><ul><li>Username: <code>admin</code></li><li>Password: <code>admin</code></li></ul><p>Please <strong>change your admin password</strong> before you make Teamscale available to others.</p></details><details class="details custom-block"><summary>Can I configure Teamscale to synchronize users from my LDAP / Active Directory?</summary><p><strong>Yes</strong>. Please see <a href="./../howto/importing-users/">the article on importing users</a>.</p></details><details class="details custom-block"><summary>Does Teamscale support Single sign-on (SSO)?</summary><p><strong>Yes</strong>. Teamscale supports authentication via <a href="./../howto/importing-users/#single-sign-on-using-saml-2-0-or-openid-connect">SAML 2.0 and OpenID Connect</a>.</p></details><details class="details custom-block"><summary>How often does Teamscale synchronize with LDAP?</summary><p>By default, Teamscale does not automatically synchronize with LDAP, but this can be configured for each connection in <em>Admin</em> &gt; <em>Settings</em> &gt; <em>LDAP</em>.</p></details><details class="details custom-block"><summary>Can I configure users manually?</summary><p><strong>Yes</strong>. Teamscale comes with a built-in user management system. Please see the <em>Users</em> perspective.</p></details><details class="details custom-block"><summary>What is an Access Key?</summary><p>The Access Key has to be used instead of your password when the authorization takes place outside of Teamscale&#39;s Web UI (e.g., from your IDE or when using the REST API).</p></details><p><span id="generate-access-key"></span></p><details class="details custom-block"><summary>Where can I get my Access Key?</summary><p>In Teamscale&#39;s Web UI, click on your avatar in the upper right corner, then choose <em>Access Keys</em>.</p></details><h2 id="configuration-customization" tabindex="-1">Configuration &amp; Customization <a class="header-anchor" href="#configuration-customization" aria-label="Permalink to &quot;Configuration &amp; Customization&quot;">​</a></h2><details class="details custom-block"><summary>Can I add multiple repositories to a single Teamscale project?</summary><p><strong>Yes</strong>, the number of repositories per project is unrestricted.</p></details><details class="details custom-block"><summary>Can I configure a project to contain multiple programming languages?</summary><p><strong>Yes</strong>, simply create a new analysis profile and select your target languages in the first step.</p></details><details class="details custom-block"><summary>Can Teamscale analyze branches?</summary><p><strong>Yes</strong>, each Teamscale project can be configured to analyze all repository branches that you are interested in.</p></details><details class="details custom-block"><summary>Does Teamscale analyze deleted branches?</summary><p>It depends on <em>when</em> the branch was deleted, but Teamscale can often reconstruct deleted branches. Teamscale will then analyze these deleted branches just like regular branches.</p></details><details class="details custom-block"><summary>Can I configure which branch should be considered the &quot;main&quot; branch?</summary><p><strong>Yes</strong>. The <em>Default branch name</em> can be set in the project configuration.</p></details><details class="details custom-block"><summary>Can I exclude certain parts of my repository from analysis?</summary><p><strong>Yes</strong>. This is possible with the <em>Include</em> &amp; <em>Exclude File Patterns</em> options in the project configuration.</p></details><details class="details custom-block"><summary>Can I exclude certain files of my repository based on the file content?</summary><p><strong>Yes</strong>. This is possible with the <strong>Content Exclude</strong> option in the project configuration.</p></details><details class="details custom-block"><summary>Can I add my own metrics to Teamscale?</summary><p><strong>Yes</strong>. Teamscale supports two kind of so-called <strong>external metrics</strong>:</p><ol><li>External code metrics that can be calculated individually per code file</li><li>External non-code metrics (e.g., build execution times)</li></ol></details><details class="details custom-block"><summary>Can I implement my own checks?</summary><p><strong>Yes</strong>. Please take a look at Teamscale&#39;s <a href="./../reference/custom-checks/">custom check framework</a>.</p></details><details class="details custom-block"><summary>I already have my own code analyzer. Can I integrate its results to Teamscale?</summary><p><strong>Yes</strong>. To get started, please check this <a href="./../reference/upload-formats-and-samples/#example-for-json-file-format-for-teamscale-generic-findings">sample file with generic findings</a>.</p></details><details class="details custom-block"><summary>Why does Teamscale only calculate a handful of metrics? Why not more?</summary><p>We <a href="https://teamscale.com/blog/en/news/blog/maintainability-index" target="_blank" rel="noreferrer">deliberately only include metrics</a> that are <strong>easy</strong> and <strong>actionable</strong>.</p></details><details class="details custom-block"><summary>Can I see an overall rating or grade for the quality of my code?</summary><p>While you can assess related metrics using threshold configurations, we deliberately don&#39;t calculate an overall score or grade for analyzed systems. This is because in our view, this would mean aggregating unrelated things, such as code clones and code documentation.</p></details><h2 id="test-coverage-test-gap-analysis" tabindex="-1">Test Coverage &amp; Test Gap Analysis <a class="header-anchor" href="#test-coverage-test-gap-analysis" aria-label="Permalink to &quot;Test Coverage &amp; Test Gap Analysis&quot;">​</a></h2><details class="details custom-block"><summary>Does Test Gap Analysis work with multiple test stages (e.g. Unit Tests and Manual Tests)?</summary><p><strong>Yes</strong>. You can have any number of coverage sources as the test gap analysis offers a holistic view. Teamscale supports all forms of tests, including - but not limited to - unit test, component tests, automated UI tests, manual and exploratory tests.</p><p>The coverage sources can be distinguished using the <em>partition</em> label you specify during the coverage upload to Teamscale. In Teamscale, you can select at any time which coverage sources you would like to view and you can even aggregate coverage from multiple sources to answer questions like <em>&quot;Which code changes did we test in <strong>none</strong> of our test stages?&quot;</em></p></details><details class="details custom-block"><summary>Can I see the results for a specific combination of coverage sources (e.g. Exploratory Developer Tests and User Acceptance Tests)?</summary><p><strong>Yes</strong>. You can specify which coverage sources (&quot;partitions&quot;) should be taken into account for the analysis in all relevant views. In Teamscale, you can select at any time which coverage sources you would like to view and you can even aggregate coverage from multiple sources to answer questions like <em>&quot;Which code changes did we test in <strong>none</strong> of our test stages?&quot;</em></p></details><details class="details custom-block"><summary>In the Test Gap treemap, what do the individual rectangles mean?</summary><p>Each rectangle represents a <strong>method</strong> of your system. The size of the rectangles corresponds to the length of the respective methods, so larger rectangles denote longer methods.</p></details><details class="details custom-block"><summary>What do the colors in the Test Gap treemap mean?</summary><ul><li><strong>Gray</strong>: The method was not changed since the baseline (except refactorings).</li><li><strong>Red</strong>: The method was added but remained untested.</li><li><strong>Yellow</strong>: The method existed before the baseline, but remained untested after its latest modification.</li><li><strong>Green</strong>: The method (or some parts of it) was tested in its current version.</li></ul></details><details class="details custom-block"><summary>Does the Test Gap analysis also work for manual tests?</summary><p><strong>Yes.</strong> Please refer to <a href="./../howto/setting-up-profiler-tga/manual-tests/">our how-to for setting up the Test Gap analysis for manual tests</a>.</p></details><details class="details custom-block"><summary>How do I record test coverage for manual tests?</summary><p>Please refer to <a href="./../howto/setting-up-profiler-tga/manual-tests/#the-principles-behind-manual-test-coverage">our how-to for setting up the Test Gap analysis for manual tests</a> for an in-depth explanation.</p></details><details class="details custom-block"><summary>How does the Test Gap analysis know which test case or individual tester caused the test coverage?</summary><p>It does not, because it doesn&#39;t need to. The Test Gap analysis shows you code areas that were recently changed but <strong>not yet</strong> tested. For this task, it is unimportant which test case or which individual tester caused the test coverage as we are not interested in the tested code changes. All untested code changes are untested regardless of who did the testing or which test cases were used. By definition, any bugs that are still present in these untested code changes cannot have been found by any of your tests.</p><p>If you are interested in an analysis that makes use of the link between test case and test coverage, have a look at <a href="./../tutorial/improving-test-efficiency/">the Test Impact analysis</a>.</p></details><details class="details custom-block"><summary>I uploaded test coverage to branch A, but want to see its coverage on branch B. Is this possible?</summary><p><strong>Yes</strong>. The coverage will be visible for branch B as soon as A is merged into B.</p></details><details class="details custom-block"><summary>I uploaded test coverage for Teamscale project X, but project Y contains (nearly) the same code. Can I see the coverage for project Y, too?</summary><p><strong>Yes</strong>. This is called &quot;cross-annotation&quot; and can be set in the respective views or widget. The coverage of methods that are identical (source location &amp; method content) in both projects will also be visible for project Y.</p></details><p><span id="other-coverage-results"></span></p><details class="details custom-block"><summary>Why does my coverage tool report different numbers than Teamscale?</summary><p>There are two main reasons why that may happen:</p><ol><li>Teamscale always takes all source lines into account, some coverage tools only count those that were loaded at runtime.</li><li>Teamscale may deem certain lines as coverable or uncoverable where your tool has a different opinion. For an in-depth explanation, please refer to <a href="https://teamscale.com/blog/en/news/blog/what-is-code-coverage" target="_blank" rel="noreferrer">our blog post on the subject</a>.</li></ol></details><details class="details custom-block"><summary>We use Feature Flag based releases, can we still see only relevant Test Gaps for a release?</summary><p>In case you are using Feature Flags to decide which parts of your code can be accessible, it might be difficult for testers to determine which Test Gaps can actually be closed. That is because certain changes might not be executable with the version they are testing.</p><p>In that case <a href="./../howto/analyzing-issue-test-gaps/#viewing-issue-test-gaps/">Issue Test Gaps</a> can help you by showing Test Gaps only for those issues that were done for one version of the software and the corresponding feature flags.</p></details><h2 id="security" tabindex="-1">Security <a class="header-anchor" href="#security" aria-label="Permalink to &quot;Security&quot;">​</a></h2><details class="details custom-block"><summary>Does Teamscale transmit code to CQSE (or some other online destination)?</summary><p>If you have an on-premise installation, all of your code and analysis data stay on your network and only you decide where the analysis results will be transmitted (e.g., to the IDE integrations of your developers). When using Teamscale&#39;s Cloud offering, the code will be transferred to and processed on a server of CQSE. To make sure that your data is safe, we have many <a href="./../reference/security/">security measures</a> in place.</p></details><details class="details custom-block"><summary>Has Teamscale ever been audited with respect to security?</summary><p><strong>Yes</strong>. We (and also some of our customers) run regular security audits and penetration tests against Teamscale. The results are used to improve both Teamscale and our development processes.</p></details><h2 id="analysis" tabindex="-1">Analysis <a class="header-anchor" href="#analysis" aria-label="Permalink to &quot;Analysis&quot;">​</a></h2><details class="details custom-block"><summary>What separates Teamscale from other static code analyzers?</summary><ol><li>Teamscale has an incremental analysis engine (see next question).</li><li>Teamscale is more than a static analyzer. It is a <em>software intelligence</em> platform, which means that it can aggregate data from multiple sources (repositories, issue tracker, build artifacts, etc.).</li></ol></details><details class="details custom-block"><summary>What does &quot;incremental analysis&quot; mean?</summary><p>Incremental analysis means that Teamscale analyzes commit by commit, as opposed to, for example, running as batch tool and analyzing the whole system again and again. Amongst other things, this means that Teamscale can</p><ul><li>give feedback almost in realtime after a commit was made,</li><li>distinguish between old and new findings, and</li><li>can display freely selectable trends.</li></ul></details><details class="details custom-block"><summary>Where does the analysis happen?</summary><p>All analyses are performed on the <strong>Teamscale server</strong>. This means that, for example, there is no slowdown of your build, and that the analysis settings are independent of local IDE settings.</p></details><details class="details custom-block"><summary>Does Teamscale&#39;s analysis need the compiled binaries (e.g., <code>.class</code> files for Java)?</summary><p><strong>No</strong>. Teamscale analyzes the source code directly and thus doesn&#39;t have to wait for a build to happen.</p></details><details class="details custom-block"><summary>Why &amp; when is a re-analysis of the projects needed?</summary><p>As Teamscale can show you the full history of your data, a re-analysis is required if the analysis parameters change. This avoids ambiguity, e.g., due to spikes in metrics trends that were only introduced by a configuration change. Correspondingly, a re-analysis is required if changes to Teamscale&#39;s analysis configuration were made.</p></details><details class="details custom-block"><summary>How fast do I get feedback after a commit?</summary><p>After a commit was pushed to the repository, a typical analysis takes only a couple of seconds. For large commits like merges, it might also take a couple of minutes, but usually not longer than 5 minutes.</p></details><details class="details custom-block"><summary>Does Teamscale only analyze the changed files per commit?</summary><p>While most of the analysis works on a per-file basis, Teamscale always knows the full system context. This means that, for example, the clone detection will recognize copy-and-pasted code in a new file that was copied from an existing, but untouched file.</p></details><details class="details custom-block"><summary>Can I choose the start and end date of trends?</summary><p><strong>Yes</strong>. You can freely choose the start and end date for all charts and views.</p></details><h2 id="findings-findings-management" tabindex="-1">Findings &amp; Findings Management <a class="header-anchor" href="#findings-findings-management" aria-label="Permalink to &quot;Findings &amp; Findings Management&quot;">​</a></h2><details class="details custom-block"><summary>What exactly is a &quot;finding&quot;?</summary><p>Generally speaking, a finding refers to a piece of code that is not as good as it <em>could</em> be. This can, for example, be a bug in your code, or a violation against your coding guidelines.</p></details><details class="details custom-block"><summary>Teamscale reports thousands of findings for my system, is this normal?</summary><p>It is very common to see a huge number of overall findings, especially for long-lived systems. Please also see the next question.</p></details><details class="details custom-block"><summary>How can I filter the findings?</summary><p>For example in the Findings perspective, by</p><ul><li>filtering based on the finding&#39;s <strong>group</strong> or specific <strong>type</strong></li><li>focusing on findings that were <strong>recently introduced</strong> by <a href="./../reference/ui/general-ui-features/#baselines-quality-goal-setting">setting a baseline</a>.</li></ul></details><details class="details custom-block"><summary>Can I configure which findings should be treated as &quot;critical&quot; / &quot;non-critical&quot;?</summary><p><strong>Yes</strong>, the severity of every finding type can be set to &quot;red&quot; (critical), &quot;yellow&quot; (non-critical), or &quot;off&quot; (no reporting).</p></details><details class="details custom-block"><summary>I don&#39;t want Teamscale to report a certain type of finding anymore. How can I do that?</summary><p>You can turn off the finding type in the analysis profile that your project uses (<em>Projects</em> &gt; <em>Analysis Profiles</em>).</p></details><details class="details custom-block"><summary>Can I permanently ignore a finding?</summary><p><strong>Yes</strong>. You can mark the finding as &quot;tolerated&quot; or &quot;false positive&quot; in the findings details view. See also next question.</p></details><details class="details custom-block"><summary>What happens if someone marks a finding as &quot;tolerated&quot; or &quot;false-positive&quot;?</summary><p>The finding will no longer by reported by Teamscale, which includes future changes to the file, as well as potential merges to other branches.</p></details><details class="details custom-block"><summary>Will findings marked as &quot;tolerated&quot; / &quot;false-positive&quot; be reported again after a Teamscale update?</summary><p><strong>No</strong>. As long as you <a href="./../howto/handling-backups/">export a project backup</a> with your previous Teamscale version, the excluded findings will still be excluded after the update.</p></details><details class="details custom-block"><summary>Can I see which findings have already been marked as &quot;tolerated&quot; or &quot;false-positive&quot;?</summary><p><strong>Yes</strong>. Please see the respective tabs in the <em>Findings</em> perspective.</p></details><details class="details custom-block"><summary>Can I configure which users should be allowed to mark findings as &quot;tolerated&quot; / &quot;false positive&quot;?</summary><p><strong>Yes</strong>. Users need the <em>Mark Yellow Findings</em> and/or <em>Mark Red Findings</em> permission (e.g., via the <em>Project Administrator</em> role).</p></details><details class="details custom-block"><summary>Can I see which commit introduced a specific finding?</summary><p><strong>Yes</strong>. In the findings detail view, the introduction commit is linked, along with the introduction diff.</p></details><details class="details custom-block"><summary>After I removed a finding, will Teamscale still know it existed?</summary><p><strong>Yes</strong>. As Teamscale analyzed the full repository history, removed findings will be known to Teamscale.</p></details><h2 id="misc" tabindex="-1">Misc <a class="header-anchor" href="#misc" aria-label="Permalink to &quot;Misc&quot;">​</a></h2><details class="details custom-block"><summary>Who develops Teamscale?</summary><p>Teamscale is built by the great team at <a href="https://teamscale.com/about-us" target="_blank" rel="noreferrer">CQSE GmbH</a>.</p></details><details class="details custom-block"><summary>I found a bug or have a feature request, how can I report it?</summary><p>Please don&#39;t hesitate to contact <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a> for all of your questions.</p></details><details class="details custom-block"><summary>I have a question, where can I find answers?</summary><p>In case this documentation didn&#39;t answer your question, <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">we are happy to help</a>.</p></details><details class="details custom-block"><summary>In which programming language is Teamscale written?</summary><p>Teamscale&#39;s backend is written in <strong>Java</strong>, whereas the Web UI is built with <strong>TypeScript</strong>.</p></details><details class="details custom-block"><summary>Is it &quot;TeamScale&quot; or &quot;Teamscale&quot;?</summary><p>It&#39;s <strong>Teamscale</strong>, so no CamelCase notation, please 😉</p></details>',89)])])}const p=s(i,[["render",n]]);export{h as __pageData,p as default};
