This plugin will look for usage of ``tarfile.extractall()``

Severity are set as follows:

* ``tarfile.extractalll(members=function(tarfile))`` - LOW
* ``tarfile.extractalll(members=?)`` - member is not a function - MEDIUM
* ``tarfile.extractall()`` - members from the archive is trusted - HIGH

Use ``tarfile.extractall(members=function_name)`` and define a function
that will inspect each member. Discard files that contain a directory
traversal sequences such as ``../`` or ``\..`` along with all special filetypes
unless you explicitly need them.

## Example


In the following code snippet the issue is: [B202:tarfile_unsafe_members] tarfile.extractall used without
any validation. You should check members and discard dangerous ones
For more information on this see: CWE-22 (https://cwe.mitre.org/data/definitions/22.html)
More Info:
https://bandit.readthedocs.io/en/latest/plugins/b202_tarfile_unsafe_members.html
``` python
    tar = tarfile.open(filename)
    tar.extractall(path=tempfile.mkdtemp())
    tar.close()
```
## see also:

- https://docs.python.org/3/library/tarfile.html#tarfile.TarFile.extractall
- https://docs.python.org/3/library/tarfile.html#tarfile.TarInfo

New in version  1.7.5
