Ensures that self-closing tags are used for elements with a closing tag but no content.

- Type: layout
- 🔧 Supports autofix (`--fix`)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<my-component></my-component>
              ~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<my-component type="text" [name]="foo"></my-component>
                                       ~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<my-component
  type="text"
  [name]="foo"
  [items]="items">
</my-component>
~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<my-component
  type="text"
  [name]="foo"
  [items]="items"
></my-component>
 ~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-template></ng-template>
             ~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-template> </ng-template>
              ~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-content></ng-content>
            ~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-content
  selector="my-selector"
></ng-content>
 ~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-content>
</ng-content>
~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<my-component type="text" [name]="foo">With some content</my-component>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<my-component />
```

<br>

---

<br>

#### ✅ Valid Code

```html
<my-component
  type="text"
  [name]="foo"
  [items]="items" />
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img />
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-template/>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-template>Content</ng-template>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-content/>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-content select="my-selector" />
```

</details>
