Local variables should be defined before the are referenced.

### Anti-pattern

In this example, `func` attempts to increment `my_var` while also defining a new local variable called `my_var`. It is not referencing the `my_var` variable from the global namespace.

```python
my_var = 0

def func():
    my_var += 1
```

### Best practice

In this example, we use the `global` statement to indicate that the function `func` should work on the variable `my_var` from the global namespace.

```python
my_var = 0

def func():
    global my_var
    my_var += 1
```
