### SCS0017 - Request Validation Disabled (Attribute) 

Request validation is disabled. Request validation allows the filtering of some [XSS](#SCS0029) patterns submitted to the application.

#### Risk

[XSS](#SCS0029)

#### Vulnerable Code

```cs
public class TestController
{
    [HttpPost]
    [ValidateInput(false)]
    public ActionResult ControllerMethod(string input) {
        return f(input);
    }
}

```

#### Solution

Although it performs blacklisting (that is worse than whitelisting by definition) and you should not rely solely on it for XSS protection, it provides a first line of defense for your application. Do not disable the validation:

```cs
public class TestController
{
    [HttpPost]
    public ActionResult ControllerMethod(string input) {
        return f(input);
    }
}

```

Always user proper encoder (Html, Url, etc.) before displaying or using user supplied data (even if it is loaded from database).

#### References

[CWE-554: ASP.NET Misconfiguration: Not Using Input Validation Framework](https://cwe.mitre.org/data/definitions/554.html)  
[MSDN: Request Validation in ASP.NET](https://msdn.microsoft.com/en-us/library/hh882339%28v=vs.110%29.aspx)  
[OWASP: ASP.NET Request Validation](https://www.owasp.org/index.php/ASP.NET%5FRequest%5FValidation)  
See [XSS](#SCS0029) references.

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)