<h2>Why is this an issue?</h2>
<p>The <code>Obsolete</code> attribute can be applied with or without a message argument. Marking something <code>Obsolete</code> without including
advice on why it’s obsolete or what to use instead will lead maintainers to waste time trying to figure those things out.</p>
<h3>Noncompliant code example</h3>
<pre>
public class Car
{

  [Obsolete]  // Noncompliant
  public void CrankEngine(int turnsOfCrank)
  { ... }
}
</pre>
<h3>Compliant solution</h3>
<pre>
public class Car
{

  [Obsolete("Replaced by the automatic starter")]
  public void CrankEngine(int turnsOfCrank)
  { ... }
}
</pre>

