<h2>Why is this an issue?</h2>
<p>Caller information attributes: <code>CallerFilePathAttribute</code>, <code>CallerLineNumberAttribute</code>, and
<code>CallerArgumentExpressionAttribute</code> provide a way to get information about the caller of a method through optional parameters. But the
arguments for these optional parameters are only generated if they are not explicitly defined in the call. Thus, specifying the argument values
defeats the purpose of the attributes.</p>
<h3>Noncompliant code example</h3>
<pre>
void TraceMessage(string message,
  [CallerFilePath] string filePath = null,
  [CallerLineNumber] int lineNumber = 0)
{
  /* ... */
}

void MyMethod()
{
  TraceMessage("my message", "A.B.C.Foo.cs", 42); // Noncompliant
}
</pre>
<h3>Compliant solution</h3>
<pre>
void TraceMessage(string message,
  [CallerFilePath] string filePath = "",
  [CallerLineNumber] int lineNumber = 0)
{
  /* ... */
}

void MyMethod()
{
  TraceMessage("my message");
}
</pre>
<h3>Exceptions</h3>
<p><code>CallerMemberName</code> is not checked to avoid False-Positives with WPF/UWP applications.</p>

