<h2>Why is this an issue?</h2>
<p>The use of <code>==</code> to compare two objects is expected to do a reference comparison. That is, it is expected to return <code>true</code> if
and only if they are the same object instance. Overloading the operator to do anything else will inevitably lead to the introduction of bugs by
callers.</p>
<pre>
public static bool operator ==(MyType x, MyType y) // Noncompliant: confusing for the caller
{
    // custom implementation
}
</pre>
<p>On the other hand, overloading it to do exactly that is pointless; that’s what <code>==</code> does by default.</p>
<pre>
public static bool operator ==(MyType x, MyType y) // Noncompliant: redundant
{
    if (x == null)
    {
        return y == null;
    }

    return object.ReferenceEquals(x,y);
}
</pre>
<h3>Exceptions</h3>
<ul>
  <li> Classes with overloaded <code>operator +</code> or <code>operator -</code> are ignored. </li>
  <li> Classes that implement <code>IComparable&lt;T&gt;</code> or <code>IEquatable&lt;T&gt;</code> most probably behave as value-type objects and are
  ignored. </li>
</ul>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/reference-types">Reference types</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/equality-operators">Equality operators</a> </li>
</ul>

