<h2>Why is this an issue?</h2>
<p>The value of a <code>static readonly</code> field is computed at runtime while the value of a <code>const</code> field is calculated at compile
time, which improves performance.</p>
<p>This rule raises an issue when a <code>static readonly</code> field is initialized with a value that is computable at compile time.</p>
<p>As specified by Microsoft, the list of types that can have a constant value are:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>C# type</th>
      <th>.Net Fwk type</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p>bool</p></td>
      <td><p>System.Boolean</p></td>
    </tr>
    <tr>
      <td><p>byte</p></td>
      <td><p>System.Byte</p></td>
    </tr>
    <tr>
      <td><p>sbyte</p></td>
      <td><p>System.SByte</p></td>
    </tr>
    <tr>
      <td><p>char</p></td>
      <td><p>System.Char</p></td>
    </tr>
    <tr>
      <td><p>decimal</p></td>
      <td><p>System.Decimal</p></td>
    </tr>
    <tr>
      <td><p>double</p></td>
      <td><p>System.Double</p></td>
    </tr>
    <tr>
      <td><p>float</p></td>
      <td><p>System.Single</p></td>
    </tr>
    <tr>
      <td><p>int</p></td>
      <td><p>System.Int32</p></td>
    </tr>
    <tr>
      <td><p>uint</p></td>
      <td><p>System.UInt32</p></td>
    </tr>
    <tr>
      <td><p>long</p></td>
      <td><p>System.Int64</p></td>
    </tr>
    <tr>
      <td><p>ulong</p></td>
      <td><p>System.UInt64</p></td>
    </tr>
    <tr>
      <td><p>short</p></td>
      <td><p>System.Int16</p></td>
    </tr>
    <tr>
      <td><p>ushort</p></td>
      <td><p>System.UInt16</p></td>
    </tr>
    <tr>
      <td><p>string</p></td>
      <td><p>System.String</p></td>
    </tr>
  </tbody>
</table>
<h3>Noncompliant code example</h3>
<pre>
namespace myLib
{
  public class Foo
  {
    static readonly int x = 1;  // Noncompliant
    static readonly int y = x + 4; // Noncompliant
    static readonly string s = "Bar";  // Noncompliant
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
namespace myLib
{
  public class Foo
  {
    const int x = 1;
    const int y = x + 4;
    const string s = "Bar";
  }
}
</pre>

