<h2>Why is this an issue?</h2>
<p>The .NET framework class library provides methods for retrieving custom attributes. Sealing the attribute eliminates the search through the
inheritance hierarchy, and can improve performance.</p>
<p>This rule raises an issue when a public type inherits from <code>System.Attribute</code>, is not abstract, and is not sealed.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

public class MyAttribute: Attribute // Noncompliant
{
    public string Name { get; }

    public MyAttribute(string name) =&gt;
        Name = name;
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

public sealed class MyAttribute : Attribute
{
    public string Name { get; }

    public MyAttribute(string name) =&gt;
        Name = name;
}
</pre>

