<h2>Why is this an issue?</h2>
<p>Operator overloading is convenient but unfortunately not portable across languages. To be able to access the same functionality from another
language you need to provide an alternate named method following the convention:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>Operator</th>
      <th>Method Name</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p><code>+</code> (binary)</p></td>
      <td><p>Add</p></td>
    </tr>
    <tr>
      <td><p><code>&amp;</code></p></td>
      <td><p>BitwiseAnd</p></td>
    </tr>
    <tr>
      <td><p><code>|</code></p></td>
      <td><p>BitwiseOr</p></td>
    </tr>
    <tr>
      <td><p><code>/</code></p></td>
      <td><p>Divide</p></td>
    </tr>
    <tr>
      <td><p><code>==</code></p></td>
      <td><p>Equals</p></td>
    </tr>
    <tr>
      <td><p><code>^</code></p></td>
      <td><p>Xor</p></td>
    </tr>
    <tr>
      <td><p><code>&gt;</code></p></td>
      <td><p>Compare</p></td>
    </tr>
    <tr>
      <td><p><code>&gt;=</code></p></td>
      <td><p>Compare</p></td>
    </tr>
    <tr>
      <td><p><code>!=</code></p></td>
      <td><p>Equals</p></td>
    </tr>
    <tr>
      <td><p><code>&lt;</code></p></td>
      <td><p>Compare</p></td>
    </tr>
    <tr>
      <td><p><code>&lt;=</code></p></td>
      <td><p>Compare</p></td>
    </tr>
    <tr>
      <td><p><code>!</code></p></td>
      <td><p>LogicalNot</p></td>
    </tr>
    <tr>
      <td><p><code>%</code></p></td>
      <td><p>Mod</p></td>
    </tr>
    <tr>
      <td><p><code>*</code> (binary)</p></td>
      <td><p>Multiply</p></td>
    </tr>
    <tr>
      <td><p><code>~</code></p></td>
      <td><p>OnesComplement</p></td>
    </tr>
    <tr>
      <td><p><code>-</code> (binary)</p></td>
      <td><p>Subtract</p></td>
    </tr>
    <tr>
      <td><p><code>-</code> (unary)</p></td>
      <td><p>Negate</p></td>
    </tr>
    <tr>
      <td><p><code>+</code> (unary)</p></td>
      <td><p>Plus</p></td>
    </tr>
  </tbody>
</table>
<p>This rule raises an issue when there is an operator overload without the expected named alternative method.</p>
<h3>Exceptions</h3>
<p>This rule does not raise an issue when the class implementing the comparison operators <code>&gt;</code>, <code>&lt;</code>, <code>&gt;=</code> and
<code>&lt;=</code> contains a method named <code>CompareTo</code>.</p>

