## SA1137

<table>
<tr>
  <td>TypeName</td>
  <td>SA1137ElementsShouldHaveTheSameIndentation</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1137</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

Two sibling elements which each start on their own line have different levels of indentation.

## Rule description

A violation of this rule occurs when two or more sibling elements each start on their own line but are not indented the
same amount.

For example, the following code would produce a violation of this rule:

```csharp
public void MethodName()
{
    A();
   B(); // SA1137: Expected the indentation to match the previous line
}
```

The following code would not produce any violations:

```csharp
public void MethodName()
{
    A();
    B();
}
```

Note that relative indentation and indentation in independent groups of siblings is not checked by this rule. The
following code shows a more complex example which would not produce any violations:

```csharp
public void Method1()
{
    A();
    B();
}

public void Method2()
{
        A();
        B();
}

public void Method3()
{
A();
B();
}

public void Method4()
    {
    A();
    B();
    }
```

### Attributes

Attribute lists are evaluated by this rule as individual elements at the same level as the element they are applied to.
However, when determining the expected indentation for sibling elements, attribute lists are given lower priority. In
other words, the first element in the same group which starts on its own line, if one exists, determines the expected
indentation for the group. If no such element exists, the indentation of the first attribute list is used instead. For
example, the following code shows locations where SA1137 is reported relative to attribute lists.

```csharp
  [Obsolete]                // SA1137 (expected no indentation)
public void Method()        // OK (this line establishes indentation for the group)
{
}

  public Task MethodAsync() // SA1137 (expected no indentation)
    {                       // OK (not part of the analysis group)
    }
```

The following example shows a case where the indentation of an attribute list *is* used for the group.

```csharp
public void Method(int x,   // Ignored (parameter does not start on its own line)
    [In] int y,             // OK (this line establishes indentation for the group)
      [In] int z)           // SA1137
{
}
```

### Labels

Labels which appear within a block statement are evaluated in a special manner. Each label within a block is expected to
have the same indentation, even if that indentation differs from the indentation used by statements within the block.
The specific indentation of labels relative to other statements is not examined for this rule.

The following example shows a block with statements and labels.

```csharp
public int MethodName()
{
    int x;

  beginning:    // OK (label indentation may differ from other statements)
     x = 3;     // SA1137 (should be indented four spaces to match 'int x;' above)

end:            // SA1137 (should be indented two spaces to match 'beginning:' above)
    return x;
}
```

Inside of a `switch` statement, the `case` and `default` labels form an additional category. The specific rules in this
case are:

1. `case` and `default` labels in a `switch` statement need to use the same indentation.
2. Other labels in a `switch` statement need to use the same indentation (but this may differ from the indentation of
   `case` labels)
3. Statements in a `switch` statement need to use the same indentation (but this may differ from both of the above
   labels).

## How to fix violations

To fix a violation of this rule, adjust the indentation of sibling elements to match.

## How to suppress violations

```csharp
class TypeName { }

#pragma warning disable SA1137 // Elements should have the same indentation
  class Indented { }
#pragma warning restore SA1137 // Elements should have the same indentation
```
