# SA1216

<table>
<tr>
  <td>TypeName</td>
  <td>SA1216UsingStaticDirectivesMustBePlacedAtTheCorrectLocation</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1216</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

A `using static` directive is positioned at the wrong location (before a regular using directive or after an alias using directive).

## Rule description

A violation of this rule occurs when a using static directive is placed before a normal or after an alias using directive. Placing the using static directives together below normal and before alias using-directives can make the code cleaner and easier to read, and can help make it easier to identify the static members used throughout the code.

## How to fix violations

The fix an instance of this violation, place the `using static` directive after regular and before alias using directives.

## How to suppress violations

```csharp
#pragma warning disable SA1216 // Using static directives should be placed at the correct location
using static System.Math;
#pragma warning restore SA1216 // Using static directives should be placed at the correct location
```
