﻿## SA1309

<table>
<tr>
  <td>TypeName</td>
  <td>SA1309FieldNamesMustNotBeginWithUnderscore</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1309</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

## Cause

A field name in C# begins with an underscore.

## Rule description

A violation of this rule occurs when a field name begins with an underscore.

By default, StyleCop disallows the use of underscores, *m_*, etc., to mark local class fields, in favor of the 'this.' prefix. The advantage of using 'this.' is that it applies equally to all element types including methods, properties, etc., and not just fields, making all calls to class members instantly recognizable, regardless of which editor is being used to view the code. Another advantage is that it creates a quick, recognizable differentiation between instance members and static members, which will not be prefixed.

If the field or variable name is intended to match the name of an item associated with Win32 or COM, and thus needs to begin with an underscore, place the field or variable within a special *NativeMethods* class. A NativeMethods class is any class which contains a name ending in NativeMethods, and is intended as a placeholder for Win32 or COM wrappers. StyleCop will ignore this violation if the item is placed within a NativeMethods class.

## How to fix violations

To fix a violation of this rule, remove the underscore from the beginning of the field name, or place the item within a NativeMethods class if appropriate.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.NamingRules", "SA1309:FieldNamesMustNotBeginWithUnderscore", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1309 // FieldNamesMustNotBeginWithUnderscore
#pragma warning restore SA1309 // FieldNamesMustNotBeginWithUnderscore
```
