﻿## SA1600

<table>
<tr>
  <td>TypeName</td>
  <td>SA1600ElementsMustBeDocumented</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1600</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

A C# code element is missing a documentation header.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs if an element is completely missing a documentation header, or if the header is empty. In C# the following types of elements can have documentation headers: classes, constructors, delegates, enums, events, finalizers, indexers, interfaces, methods, properties, and structs.

## How to fix violations

To fix a violation of this rule, add or fill-in a documentation header for the element.

The following example shows a method with a valid documentation header:

```csharp
/// <summary>
/// Joins a first name and a last name together into a single string.
/// </summary>
/// <param name="firstName">The first name to join.</param>
/// <param name="lastName">The last name to join.</param>
/// <returns>The joined names.</returns>
public string JoinNames(string firstName, string lastName)
{
    return firstName + " " + lastName;
}
```

The next example shows a method that inherits documentation from a method in the base class:

```csharp
/// <summary>
/// Example base class.
/// </summary>
class Vehicle 
{
  /// <summary>
  /// Accelerates the vehicle.
  /// </summary>
  public virtual void Accelerate()
  {                    
    Console.WriteLine("Vehicle is accelerating");
  }
}

/// <summary>
/// Example derived class.
/// </summary>
class Car : Vehicle
{
  /// <inheritdoc/>
  public override void Accelerate()
  {
    Console.Writeline("Car is accelerating");
  }
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1600:ElementsMustBeDocumented", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1600 // ElementsMustBeDocumented
#pragma warning restore SA1600 // ElementsMustBeDocumented
```
