﻿## SA1625

<table>
<tr>
  <td>TypeName</td>
  <td>SA1625ElementDocumentationMustNotBeCopiedAndPasted</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1625</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The Xml documentation for a C# element contains two or more identical entries, indicating that the documentation has been copied and pasted. This can sometimes indicate invalid or poorly written documentation.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when an element contains two or more identical documentation texts. For example:

```csharp
/// <summary>
/// Joins a first name and a last name together into a single string.
/// </summary>
/// <param name="firstName">Part of the name.</param>
/// <param name="lastName">Part of the name.</param>
/// <returns>The joined names.</returns>
public string JoinNames(string firstName, string lastName)
{
    return firstName + " " + lastName;
}
```

In some cases, a method may contain one or more parameters which are not used within the body of the method. In this case, the documentation for the parameter can be set to "The parameter is not used." StyleCop will allow multiple parameters to contain identical documentation as long as the documentation string is "The parameter is not used."

## How to fix violations

To fix a violation of this rule, edit the documentation for the element and ensure that each of the individual documentation texts are unique. For example:

```csharp
/// <summary>
/// Joins a first name and a last name together into a single string.
/// </summary>
/// <param name="firstName">The first name to join.</param>
/// <param name="lastName">The last name to join.</param>
/// <returns>The joined names.</returns>
public string JoinNames(string firstName, string lastName)
{
    return firstName + " " + lastName;
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1625:ElementDocumentationMustNotBeCopiedAndPasted", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1625 // ElementDocumentationMustNotBeCopiedAndPasted
#pragma warning restore SA1625 // ElementDocumentationMustNotBeCopiedAndPasted
```
