<h2>Why is this an issue?</h2>
<p>It is preferable to place string literals on the left-hand side of an <code>equals()</code> or <code>equalsIgnoreCase()</code> method call.</p>
<p>This prevents null pointer exceptions from being raised, as a string literal can never be null by definition.</p>
<h3>Noncompliant code example</h3>

```java
String myString = null;

System.out.println("Equal? " + myString.equals("foo"));                        // Noncompliant; will raise a NPE
System.out.println("Equal? " + (myString != null && myString.equals("foo")));  // Noncompliant; null check could be removed
```
<h3>Compliant solution</h3>

```java
System.out.println("Equal?" + "foo".equals(myString));                         // properly deals with the null case
```