<h2>Why is this an issue?</h2>
<p>When you call <code>isEmpty()</code>, it clearly communicates the code’s intention, which is to check if the collection is empty. Using
<code>size() == 0</code> for this purpose is less direct and makes the code slightly more complex.</p>
<p>Moreover, depending on the implementation, the <code>size()</code> method can have a time complexity of <code>O(n)</code> where <code>n</code> is
the number of elements in the collection. On the other hand, <code>isEmpty()</code> simply checks if there is at least one element in the collection,
which is a constant time operation, <code>O(1)</code>.</p>

```java
public class MyClass {
  public void doSomething(Collection<String> myCollection) {
    if (myCollection.size() == 0) { // Noncompliant
      doSomethingElse();
    }
  }
}
```
<p>Prefer using <code>isEmpty()</code> to test for emptiness over <code>size()</code>.</p>

```java
public class MyClass {
  public void doSomething(Collection<String> myCollection) {
    if (myCollection.isEmpty()) {
      doSomethingElse();
    }
  }
}
```