<h2>Why is this an issue?</h2>
<p>Java’s <code>import</code> mechanism allows the use of simple class names. Therefore, using a class' fully qualified name in a file that
<code>import</code>s the class is redundant and confusing.</p>
<h3>Noncompliant code example</h3>

```java
import java.util.List;
import java.sql.Timestamp;

//...

java.util.List<String> myList;  // Noncompliant
java.sql.Timestamp tStamp; // Noncompliant
```
<h3>Compliant solution</h3>

```java
import java.util.List;
import java.sql.Timestamp;

//...

List<String> myList;
Timestamp tStamp;
```