<h2>Why is this an issue?</h2>
<p>In a multithreaded environment, a thread may need to wait for a particular condition to become true. One way of pausing execution in Java is
<code>Thread.sleep(…​)</code>.</p>
<p>If a thread that holds a lock calls <code>Thread.sleep(…​)</code>, no other thread can acquire said lock. This can lead to performance and
scalability issues, in the worst case leading to deadlocks.</p>
<h2>How to fix it</h2>
<p>Call <code>wait(…​)</code> on the monitor object instead of using <code>Thread.sleep(…​)</code>. While <code>wait(…​)</code> is executed, the lock
is temporarily released and hence other threads can run in the meantime.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public void doSomething(){
  synchronized(monitor) {
    while(notReady()){
      Thread.sleep(200); // Noncompliant, any other thread synchronizing on monitor is blocked from running while the first thread sleeps.
    }
    process();
  }
  ...
}
```
<h4>Compliant solution</h4>

```java
public void doSomething(){
  synchronized(monitor) {
    while(notReady()){
      monitor.wait(200); // Compliant, the current monitor is released.
    }
    process();
  }
  ...
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/YTdGBQ">CERT, LCK09-J.</a> - Do not perform operations that can block while holding a lock </li>
</ul>