<h2>Why is this an issue?</h2>
<p>Fields, parameters and return values marked <code>@NotNull</code>, <code>@NonNull</code>, or <code>@Nonnull</code> are assumed to have non-null
values and are not typically null-checked before use. Therefore setting one of these values to <code>null</code>, or failing to set such a class field
in a constructor, could cause <code>NullPointerException</code>s at runtime.</p>
<h3>Noncompliant code example</h3>

```java
public class MainClass {

  @Nonnull
  private String primary;
  private String secondary;

  public MainClass(String color) {
    if (color != null) {
      secondary = null;
    }
    primary = color;  // Noncompliant; "primary" is Nonnull but could be set to null here
  }

  public MainClass() { // Noncompliant; "primary" is Nonnull but is not initialized
  }

  @Nonnull
  public String indirectMix() {
    String mix = null;
    return mix;  // Noncompliant; return value is Nonnull, but null is returned.
  }
```
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> CERT - <a href="https://wiki.sei.cmu.edu/confluence/x/QdcxBQ">EXP34-C. Do not dereference null pointers</a> </li>
  <li> CERT - <a href="https://wiki.sei.cmu.edu/confluence/display/java/EXP01-J.+Do+not+use+a+null+in+a+case+where+an+object+is+required">EXP01-J. Do
  not use a null in a case where an object is required</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/476">CWE-476 NULL Pointer Dereference</a> </li>
</ul>