<h2>Why is this an issue?</h2>
<p>Correctly updating a <code>static</code> field from a non-static method is tricky to get right and could easily lead to bugs if there are multiple
class instances and/or multiple threads in play. Ideally, <code>static</code> fields are only updated from <code>synchronized static</code>
methods.</p>
<p>This rule raises an issue each time a <code>static</code> field is updated from a non-static method.</p>
<h3>Noncompliant code example</h3>

```java
public class MyClass {

  private static int count = 0;

  public void doSomething() {
    //...
    count++;  // Noncompliant
  }
}
```
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222567">Application Security and
  Development: V-222567</a> - The application must not be vulnerable to race conditions. </li>
</ul>