<h2>Why is this an issue?</h2>
<p><code>Map</code> is an object that maps keys to values. A map cannot contain duplicate keys, which means each key can map to at most one value.</p>
<p>When both the key and the value are needed, it is more efficient to iterate the <code>entrySet()</code>, which will give access to both instead of
iterating over the <code>keySet()</code> and then getting the value.</p>
<p>If the <code>entrySet()</code> method is not iterated when both the key and value are needed, it can lead to unnecessary lookups. This is because
each lookup requires two operations: one to retrieve the key and another to retrieve the value. By iterating the <code>entrySet()</code> method, the
key-value pair can be retrieved in a single operation, which can improve performance.</p>
<h3>Noncompliant code example</h3>

```java
public void doSomethingWithMap(Map<String,Object> map) {
  for (String key : map.keySet()) {  // Noncompliant; for each key the value is retrieved
    Object value = map.get(key);
    // ...
  }
}
```
<h3>Compliant solution</h3>

```java
public void doSomethingWithMap(Map<String,Object> map) {
  for (Map.Entry<String,Object> entry : map.entrySet()) {
    String key = entry.getKey();
    Object value = entry.getValue();
    // ...
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/util/Map.html">Oracle SE 20 - Map</a> </li>
</ul>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> <a href="https://www.baeldung.com/java-map-entries-methods">Baeldung - Java Map methods</a> </li>
</ul>