<h2>Why is this an issue?</h2>
<p>The <code>ThreadGroup</code> class contains many deprecated methods like <code>allowThreadSuspension</code>, <code>resume</code>,
<code>stop</code>, and <code>suspend</code>. Also, some of the non-deprecated methods are obsolete or not thread-safe, and still others are insecure
(<code>activeCount</code>, <code>enumerate</code>). For these reasons, any use of <code>ThreadGroup</code> is suspicious and should be avoided.</p>
<h2>How to fix it</h2>
<p>Instead, use implementations of <code>java.util.concurrent.ExecutorService</code> to safely manage groups of threads.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
class NetworkHandler {

  void startThreadInGroup(ThreadGroup tg) { // Noncompliant, use an ExecutorService instead, which is more secure
    Thread thread = new Thread(tg, "controller");
    thread.start();
  }

}
```
<h4>Compliant solution</h4>

```java
class NetworkHandler {

  void handleThreadsProperly() {
    ThreadFactory threadFactory = Executors.defaultThreadFactory();
    ThreadPoolExecutor executorPool = new ThreadPoolExecutor(3, 10, 5, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2), threadFactory);
    for (int i = 0; i < 10; i++) {
      executorPool.execute(new Thread("Job: " + i));
    }
    executorPool.shutdown();
  }

}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/YzdGBQ">CERT, THI01-J.</a> - Do not invoke ThreadGroup methods </li>
</ul>