<h2>Why is this an issue?</h2>
<p>According to its JavaDocs, the intermediate Stream operation <code>java.util.Stream.peek()</code> “exists mainly to support debugging”
purposes.</p>
<p>A key difference with other intermediate Stream operations is that the Stream implementation is free to skip calls to <code>peek()</code> for
optimization purpose. This can lead to <code>peek()</code> being unexpectedly called only for some or none of the elements in the Stream.</p>
<p>As a consequence, relying on <code>peek()</code> without careful consideration can lead to error-prone code.</p>
<p>This rule raises an issue for each use of peek() to be sure that it is challenged and validated by the team to be meant for production
debugging/logging purposes.</p>
<h3>Noncompliant code example</h3>

```java
Stream.of("one", "two", "three", "four")
         .filter(e -> e.length() > 3)
         .peek(e -> System.out.println("Filtered value: " + e)); // Noncompliant
```
<h3>Compliant solution</h3>

```java
Stream.of("one", "two", "three", "four")
         .filter(e -> e.length() > 3)
         .foreach(e -> System.out.println("Filtered value: " + e));
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/8/docs/api/java/util/stream/Stream.html#peek-java.util.function.Consumer-">Java 8 API Documentation</a>
  </li>
  <li> 4comprehension: <a href="https://4comprehension.com/idiomatic-peeking/">Idiomatic Peeking with Java Stream API</a> </li>
  <li> Data Geekery: <a href="https://blog.jooq.org/2014/06/13/java-8-friday-10-subtle-mistakes-when-using-the-streams-api/">10 Subtle Mistakes When
  Using the Streams API</a> </li>
</ul>