<p>This rule is deprecated, and will eventually be removed.</p>
<h2>Why is this an issue?</h2>
<p>When the line immediately after a conditional has neither curly braces nor indentation, the intent of the code is unclear and perhaps not what is
executed. Additionally, such code is confusing to maintainers.</p>

```js
if (condition)  // Noncompliant
doTheThing();
doTheOtherThing(); // Was the intent to call this function unconditionally?
```
<p>It becomes even more confusing and bug-prone if lines get commented out.</p>

```js
if (condition)  // Noncompliant
//  doTheThing();
doTheOtherThing(); // Was the intent to call this function conditionally?
```
<p>Indentation alone or together with curly braces makes the intent clear.</p>

```js
if (condition)
  doTheThing();
doTheOtherThing(); // Clear intent to call this function unconditionally

// or

if (condition) {
  doTheThing();
}
doTheOtherThing(); // Clear intent to call this function unconditionally
```
<p>This rule raises an issue if the line controlled by a conditional has the same indentation as the conditional and is not enclosed in curly
braces.</p>