<h2>Why is this an issue?</h2>
<p>The <code>typeof</code> operator returns a string indicating the type of its argument, and the set of returned values is limited:</p>
<ul>
  <li> <code>"undefined"</code> </li>
  <li> <code>"boolean"</code> </li>
  <li> <code>"number"</code> </li>
  <li> <code>"string"</code> </li>
  <li> <code>"symbol"</code> (since ECMAScript 2015) </li>
  <li> <code>"function"</code> </li>
  <li> <code>"object"</code> (for <code>null</code> and any other object) </li>
  <li> <code>"bigint"</code> (since ECMAScript 2020) </li>
</ul>
<p>Compare a <code>typeof</code> expression to anything else, and the result will always be <code>false</code>.</p>

```js
function isNumber(x) {
  return typeof x === "Number"; // Noncompliant: the function always returns 'false'
}
```
<p>Instead, make sure you are always comparing the expression against one of the seven possible values.</p>

```js
function isNumber(x) {
  return typeof x === "number";
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/typeof">typeof</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures#primitive_values">Primitive values</a> </li>
</ul>