<h2>Why is this an issue?</h2>
<p>Deprecated predefined variables in PHP should not be used because they may lead to compatibility issues and unpredictable behavior in future
versions of PHP. Relying on deprecated variables can result in code that is difficult to maintain and may break when migrating to newer PHP
versions.</p>
<p>It is recommended to use the recommended alternatives or custom variables to ensure long-term compatibility and stability of PHP code.</p>
<h2>How to fix it</h2>
<p>The following predefined variables are deprecated and should be replaced by the new versions:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>Replace</th>
      <th>With</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p>$HTTP_SERVER_VARS</p></td>
      <td><p>$_SERVER</p></td>
    </tr>
    <tr>
      <td><p>$HTTP_GET_VARS</p></td>
      <td><p>$_GET</p></td>
    </tr>
    <tr>
      <td><p>$HTTP_POST_VARS</p></td>
      <td><p>$_POST</p></td>
    </tr>
    <tr>
      <td><p>$HTTP_POST_FILES</p></td>
      <td><p>$_FILES</p></td>
    </tr>
    <tr>
      <td><p>$HTTP_SESSION_VARS</p></td>
      <td><p>$_SESSION</p></td>
    </tr>
    <tr>
      <td><p>$HTTP_ENV_VARS</p></td>
      <td><p>$_ENV</p></td>
    </tr>
    <tr>
      <td><p>$HTTP_COOKIE_VARS</p></td>
      <td><p>$_COOKIE</p></td>
    </tr>
    <tr>
      <td><p>$php_errormsg</p></td>
      <td><p>error_get_last()</p></td>
    </tr>
  </tbody>
</table>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.php.net/manual/en/reserved.variables.php">PHP Manual - Predefined Variables</a> </li>
</ul>