<h2>Why is this an issue?</h2>
<p>When the same code is duplicated in two or more separate branches of a conditional, it can make the code harder to understand, maintain, and can
potentially introduce bugs if one instance of the code is changed but others are not.</p>
<p>Having two <code>cases</code> in a <code>switch</code> statement or two branches in an <code>if</code> chain with the same implementation is at
best duplicate code, and at worst a coding error.</p>

```php
if ($a >= 0 && $a < 10) {
  doFirst();
  doTheThing();
}
else if ($a >= 10 && $a < 20) {
  doTheOtherThing();
}
else if ($a >= 20 && $a < 50) {
  doFirst();
  doTheThing();  // Noncompliant; duplicates first condition
}
```

```php
switch ($i) {
  case 1:
    doFirst();
    doSomething();
    break;
  case 2:
    doSomethingDifferent();
    break;
  case 3:  // Noncompliant; duplicates case 1's implementation
    doFirst();
    doSomething();
    break;
  default:
    doTheRest();
}
```
<p>If the same logic is truly needed for both instances, then:</p>
<ul>
  <li> in an <code>if</code> chain they should be combined </li>
</ul>

```php
if (($a >= 0 && $a < 10) || ($a >= 20 && $a < 50)) {
  doFirst();
  doTheThing();
}
else if ($a >= 10 && $a < 20) {
  doTheOtherThing();
}
```
<ul>
  <li> for a <code>switch</code>, one should fall through to the other </li>
</ul>

```php
switch ($i) {
  case 1:
  case 3:
    doFirst();
    doSomething();
    break;
  case 2:
    doSomethingDifferent();
    break;
  default:
    doTheRest();
}
```
<h3>Exceptions</h3>
<p>Blocks in an <code>if</code> chain that contain a single line of code are ignored, as are blocks in a <code>switch</code> statement that contain a
single line of code with or without a following <code>break</code>.</p>

```php
if ($a >= 0 && $a < 10) {
  doTheThing();
}
else if ($a >= 10 && $a < 20) {
  doTheOtherThing();
}
else if ($a >= 20 && $a < 50) {
  doTheThing();  // no issue, usually this is done on purpose to increase the readability
}
```
<p>But this exception does not apply to <code>if</code> chains without <code>else</code>-s, or to <code>switch</code>-es without default clauses when
all branches have the same single line of code. In the case of <code>if</code> chains with <code>else</code>-s, or of <code>switch</code>-es with
default clauses, rule <a href='checks/checks/?languages=PHP&tools=SONAR_LINT&rule=php:S3923'>php:S3923</a> raises a bug.</p>

```php
if ($a >= 0 && $a < 10) {
  doTheThing();
}
else if ($a >= 20 && $a < 50) {
  doTheThing();   //Noncompliant; this might have been done on purpose but probably not
}
```
<h2>Resources</h2>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=PHP&tools=SONAR_LINT&rule=php:S3923'>php:S3923</a> - All branches in a conditional structure should not have exactly the same implementation </li>
</ul>