<h2>Why is this an issue?</h2>
<p>When using metacharacters like <code>\w</code> without the Unicode flag or when using hard-coded character classes like <code>[a-zA-Z]</code>,
letters outside of the ASCII range, such as umlauts, accented letters, or letters from non-Latin languages, won’t be matched. This may cause code to
incorrectly handle input containing such letters.</p>
<p>To correctly handle non-ASCII input, it is recommended to use the Unicode flag <code>\u</code> or Unicode character properties like
<code>\p{L}</code>.</p>
<h3>Noncompliant code example</h3>

```php
preg_match("/[a-zA-Z]/", "ö"); // returns 0
preg_match("/\w/", "ö"); // returns 0
```
<h3>Compliant solution</h3>

```php
preg_match("/\w/u", "ö"); // returns 1
preg_match("/\p{L}/", "ö"); // return 1
```