<h2>Why is this an issue?</h2>
<p>Grouping all the shorthand declarations together in an object makes the declaration as a whole more readable. This rule accepts shorthand
declarations grouped at either the beginning or end of an object.</p>
<h3>Noncompliant code example</h3>

```ts
let obj1 = {
  foo,
  a: 1,
  color,  // Noncompliant
  b: 2,
  judyGarland  // Noncompliant
}
```
<h3>Compliant solution</h3>

```ts
let obj1 = {
  foo,
  color,
  judyGarland,
  a: 1,
  b: 2
}
```
<p>or</p>

```ts
let obj1 = {
  a: 1,
  b: 2,
  foo,
  color,
  judyGarland
}
```